%------------------------------------------------------------------------------
% File     : COM198^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Computing Theory
% Problem  : Koenig's lemma (about infinite trees) 75
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : koenig__75.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.1.0
% Syntax   : Number of formulae    :  325 ( 145 unt;  60 typ;   0 def)
%            Number of atoms       :  749 ( 326 equ;   5 cnn)
%            Maximal formula atoms :   15 (   2 avg)
%            Number of connectives : 4859 (  38   ~;  10   |;  62   &;4483   @)
%                                         (   0 <=>; 266  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   22 (   9 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  779 ( 779   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   62 (  58 usr;   4 con; 0-10 aty)
%            Number of variables   : 1527 ( 214   ^;1193   !;  30   ?;1527   :)
%                                         (  74  !>;   0  ?*;   0  @-;  16  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:38:43.912
%------------------------------------------------------------------------------
%----Could-be-implicit typings (7)
thf(ty_t_TreeFI_OtreeFI,type,
    treeFI: $tType > $tType ).

thf(ty_t_Stream_Ostream,type,
    stream: $tType > $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (53)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_BNF__Def_Opick__middlep,type,
    bNF_pick_middlep: 
      !>[B: $tType,A: $tType,C: $tType] : ( ( B > A > $o ) > ( A > C > $o ) > B > C > A ) ).

thf(sy_c_BNF__Def_Orel__fun,type,
    bNF_rel_fun: 
      !>[A: $tType,C: $tType,B: $tType,D: $tType] : ( ( A > C > $o ) > ( B > D > $o ) > ( A > B ) > ( C > D ) > $o ) ).

thf(sy_c_BNF__Def_Ovimage2p,type,
    bNF_vimage2p: 
      !>[A: $tType,D: $tType,B: $tType,E: $tType,C: $tType] : ( ( A > D ) > ( B > E ) > ( D > E > C ) > A > B > C ) ).

thf(sy_c_Basic__BNFs_Opred__fun,type,
    basic_pred_fun: 
      !>[A: $tType,B: $tType] : ( ( A > $o ) > ( B > $o ) > ( A > B ) > $o ) ).

thf(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( B > C ) > ( A > B ) > A > C ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_OinfiniteTr,type,
    koenig488553731niteTr: 
      !>[A: $tType] : ( ( treeFI @ A ) > $o ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_OkonigPath,type,
    koenig1103336060igPath: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( stream @ A ) ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_OproperPath,type,
    koenig1755522246erPath: 
      !>[A: $tType] : ( ( stream @ A ) > ( treeFI @ A ) > $o ) ).

thf(sy_c_List_OBleast,type,
    bleast: 
      !>[A: $tType] : ( ( set @ A ) > ( A > $o ) > A ) ).

thf(sy_c_List_Oabort__Bleast,type,
    abort_Bleast: 
      !>[A: $tType] : ( ( set @ A ) > ( A > $o ) > A ) ).

thf(sy_c_List_Olist_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Olist_Olist__all2,type,
    list_all2: 
      !>[A: $tType,B: $tType] : ( ( A > B > $o ) > ( list @ A ) > ( list @ B ) > $o ) ).

thf(sy_c_List_Olist_Oset,type,
    set2: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Omember,type,
    member: 
      !>[A: $tType] : ( ( list @ A ) > A > $o ) ).

thf(sy_c_Orderings_Oord__class_OLeast,type,
    ord_Least: 
      !>[A: $tType] : ( ( A > $o ) > A ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Stream_Osdrop,type,
    sdrop: 
      !>[A: $tType] : ( nat > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osdrop__while,type,
    sdrop_while: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osfilter,type,
    sfilter: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( list @ A ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osinterleave,type,
    sinterleave: 
      !>[A: $tType] : ( ( stream @ A ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osmap2,type,
    smap2: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( stream @ A ) > ( stream @ B ) > ( stream @ C ) ) ).

thf(sy_c_Stream_Osmember,type,
    smember: 
      !>[A: $tType] : ( A > ( stream @ A ) > $o ) ).

thf(sy_c_Stream_Osmerge,type,
    smerge: 
      !>[A: $tType] : ( ( stream @ ( stream @ A ) ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osnth,type,
    snth: 
      !>[A: $tType] : ( ( stream @ A ) > nat > A ) ).

thf(sy_c_Stream_Ostream_OSCons,type,
    sCons: 
      !>[A: $tType] : ( A > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream_Ocase__stream,type,
    case_stream: 
      !>[A: $tType,B: $tType] : ( ( A > ( stream @ A ) > B ) > ( stream @ A ) > B ) ).

thf(sy_c_Stream_Ostream_Ocorec__stream,type,
    corec_stream: 
      !>[C: $tType,A: $tType] : ( ( C > A ) > ( C > $o ) > ( C > ( stream @ A ) ) > ( C > C ) > C > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream_Opred__stream,type,
    pred_stream: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > $o ) ).

thf(sy_c_Stream_Ostream_Oshd,type,
    shd: 
      !>[A: $tType] : ( ( stream @ A ) > A ) ).

thf(sy_c_Stream_Ostream_Osmap,type,
    smap: 
      !>[A: $tType,Aa: $tType] : ( ( A > Aa ) > ( stream @ A ) > ( stream @ Aa ) ) ).

thf(sy_c_Stream_Ostream_Osset,type,
    sset: 
      !>[A: $tType] : ( ( stream @ A ) > ( set @ A ) ) ).

thf(sy_c_Stream_Ostream_Ostl,type,
    stl: 
      !>[A: $tType] : ( ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream_Ostream__all2,type,
    stream_all2: 
      !>[A: $tType,B: $tType] : ( ( A > B > $o ) > ( stream @ A ) > ( stream @ B ) > $o ) ).

thf(sy_c_Stream_Ostream__all,type,
    stream_all: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > $o ) ).

thf(sy_c_Stream_Ostreams,type,
    streams: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( stream @ A ) ) ) ).

thf(sy_c_Stream_Ostreamsp,type,
    streamsp: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > $o ) ).

thf(sy_c_TreeFI_OtreeFI_OTree,type,
    tree: 
      !>[A: $tType] : ( A > ( list @ ( treeFI @ A ) ) > ( treeFI @ A ) ) ).

thf(sy_c_TreeFI_OtreeFI_Ocase__treeFI,type,
    case_treeFI: 
      !>[A: $tType,B: $tType] : ( ( A > ( list @ ( treeFI @ A ) ) > B ) > ( treeFI @ A ) > B ) ).

thf(sy_c_TreeFI_OtreeFI_Olab,type,
    lab: 
      !>[A: $tType] : ( ( treeFI @ A ) > A ) ).

thf(sy_c_TreeFI_OtreeFI_Omap__treeFI,type,
    map_treeFI: 
      !>[A: $tType,Aa: $tType] : ( ( A > Aa ) > ( treeFI @ A ) > ( treeFI @ Aa ) ) ).

thf(sy_c_TreeFI_OtreeFI_Opred__treeFI,type,
    pred_treeFI: 
      !>[A: $tType] : ( ( A > $o ) > ( treeFI @ A ) > $o ) ).

thf(sy_c_TreeFI_OtreeFI_Orel__treeFI,type,
    rel_treeFI: 
      !>[A: $tType,B: $tType] : ( ( A > B > $o ) > ( treeFI @ A ) > ( treeFI @ B ) > $o ) ).

thf(sy_c_TreeFI_OtreeFI_Oset__treeFI,type,
    set_treeFI: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( set @ A ) ) ).

thf(sy_c_TreeFI_OtreeFI_Osub,type,
    sub: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( list @ ( treeFI @ A ) ) ) ).

thf(sy_c_TreeFI_Otrev,type,
    trev: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( treeFI @ A ) ) ).

thf(sy_c_member,type,
    member2: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_tr,type,
    tr: treeFI @ a ).

%----Relevant facts (256)
thf(fact_0_assms,axiom,
    koenig488553731niteTr @ a @ tr ).

% assms
thf(fact_1_konigPath_Osimps_I1_J,axiom,
    ! [A: $tType,T: treeFI @ A] :
      ( ( shd @ A @ ( koenig1103336060igPath @ A @ T ) )
      = ( lab @ A @ T ) ) ).

% konigPath.simps(1)
thf(fact_2_properPath__shd__lab,axiom,
    ! [A: $tType,As: stream @ A,Tr: treeFI @ A] :
      ( ( koenig1755522246erPath @ A @ As @ Tr )
     => ( ( shd @ A @ As )
        = ( lab @ A @ Tr ) ) ) ).

% properPath_shd_lab
thf(fact_3_properPath__sub,axiom,
    ! [A: $tType,As: stream @ A,Tr: treeFI @ A,Phi: ( stream @ A ) > ( treeFI @ A ) > $o] :
      ( ( koenig1755522246erPath @ A @ As @ Tr )
     => ? [X: treeFI @ A] :
          ( ( member2 @ ( treeFI @ A ) @ X @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr ) ) )
          & ( ( Phi @ ( stl @ A @ As ) @ X )
            | ( koenig1755522246erPath @ A @ ( stl @ A @ As ) @ X ) ) ) ) ).

% properPath_sub
thf(fact_4_infiniteTr__sub,axiom,
    ! [A: $tType,Tr: treeFI @ A] :
      ( ( koenig488553731niteTr @ A @ Tr )
     => ? [X: treeFI @ A] :
          ( ( member2 @ ( treeFI @ A ) @ X @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr ) ) )
          & ( koenig488553731niteTr @ A @ X ) ) ) ).

% infiniteTr_sub
thf(fact_5_infiniteTr_Ocases,axiom,
    ! [A: $tType,A2: treeFI @ A] :
      ( ( koenig488553731niteTr @ A @ A2 )
     => ~ ! [Tr2: treeFI @ A] :
            ( ( member2 @ ( treeFI @ A ) @ Tr2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ A2 ) ) )
           => ~ ( koenig488553731niteTr @ A @ Tr2 ) ) ) ).

% infiniteTr.cases
thf(fact_6_infiniteTr_Osimps,axiom,
    ! [A: $tType] :
      ( ( koenig488553731niteTr @ A )
      = ( ^ [A3: treeFI @ A] :
          ? [Tr3: treeFI @ A,Tr4: treeFI @ A] :
            ( ( A3 = Tr4 )
            & ( member2 @ ( treeFI @ A ) @ Tr3 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr4 ) ) )
            & ( koenig488553731niteTr @ A @ Tr3 ) ) ) ) ).

% infiniteTr.simps
thf(fact_7_infiniteTr__coind,axiom,
    ! [A: $tType,Phi: ( treeFI @ A ) > $o,Tr: treeFI @ A] :
      ( ( Phi @ Tr )
     => ( ! [Tr5: treeFI @ A] :
            ( ( Phi @ Tr5 )
           => ? [X2: treeFI @ A] :
                ( ( member2 @ ( treeFI @ A ) @ X2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr5 ) ) )
                & ( Phi @ X2 ) ) )
       => ( koenig488553731niteTr @ A @ Tr ) ) ) ).

% infiniteTr_coind
thf(fact_8_properPath_Ocases,axiom,
    ! [A: $tType,A1: stream @ A,A22: treeFI @ A] :
      ( ( koenig1755522246erPath @ A @ A1 @ A22 )
     => ~ ( ( ( shd @ A @ A1 )
            = ( lab @ A @ A22 ) )
         => ! [Tr2: treeFI @ A] :
              ( ( member2 @ ( treeFI @ A ) @ Tr2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ A22 ) ) )
             => ~ ( koenig1755522246erPath @ A @ ( stl @ A @ A1 ) @ Tr2 ) ) ) ) ).

% properPath.cases
thf(fact_9_properPath_Osimps,axiom,
    ! [A: $tType] :
      ( ( koenig1755522246erPath @ A )
      = ( ^ [A12: stream @ A,A23: treeFI @ A] :
          ? [As2: stream @ A,Tr4: treeFI @ A,Tr3: treeFI @ A] :
            ( ( A12 = As2 )
            & ( A23 = Tr4 )
            & ( ( shd @ A @ As2 )
              = ( lab @ A @ Tr4 ) )
            & ( member2 @ ( treeFI @ A ) @ Tr3 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr4 ) ) )
            & ( koenig1755522246erPath @ A @ ( stl @ A @ As2 ) @ Tr3 ) ) ) ) ).

% properPath.simps
thf(fact_10_properPath__coind,axiom,
    ! [A: $tType,Phi: ( stream @ A ) > ( treeFI @ A ) > $o,As: stream @ A,Tr: treeFI @ A] :
      ( ( Phi @ As @ Tr )
     => ( ! [As3: stream @ A,Tr5: treeFI @ A] :
            ( ( Phi @ As3 @ Tr5 )
           => ( ( shd @ A @ As3 )
              = ( lab @ A @ Tr5 ) ) )
       => ( ! [As3: stream @ A,Tr5: treeFI @ A] :
              ( ( Phi @ As3 @ Tr5 )
             => ? [X2: treeFI @ A] :
                  ( ( member2 @ ( treeFI @ A ) @ X2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr5 ) ) )
                  & ( Phi @ ( stl @ A @ As3 ) @ X2 ) ) )
         => ( koenig1755522246erPath @ A @ As @ Tr ) ) ) ) ).

% properPath_coind
thf(fact_11_infiniteTr_Ointros,axiom,
    ! [A: $tType,Tr6: treeFI @ A,Tr: treeFI @ A] :
      ( ( member2 @ ( treeFI @ A ) @ Tr6 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr ) ) )
     => ( ( koenig488553731niteTr @ A @ Tr6 )
       => ( koenig488553731niteTr @ A @ Tr ) ) ) ).

% infiniteTr.intros
thf(fact_12_properPath_Ointros,axiom,
    ! [A: $tType,As: stream @ A,Tr: treeFI @ A,Tr6: treeFI @ A] :
      ( ( ( shd @ A @ As )
        = ( lab @ A @ Tr ) )
     => ( ( member2 @ ( treeFI @ A ) @ Tr6 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr ) ) )
       => ( ( koenig1755522246erPath @ A @ ( stl @ A @ As ) @ Tr6 )
         => ( koenig1755522246erPath @ A @ As @ Tr ) ) ) ) ).

% properPath.intros
thf(fact_13_infiniteTr_Ocoinduct,axiom,
    ! [A: $tType,X3: ( treeFI @ A ) > $o,X4: treeFI @ A] :
      ( ( X3 @ X4 )
     => ( ! [X: treeFI @ A] :
            ( ( X3 @ X )
           => ? [Tr7: treeFI @ A,Tr8: treeFI @ A] :
                ( ( X = Tr8 )
                & ( member2 @ ( treeFI @ A ) @ Tr7 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr8 ) ) )
                & ( ( X3 @ Tr7 )
                  | ( koenig488553731niteTr @ A @ Tr7 ) ) ) )
       => ( koenig488553731niteTr @ A @ X4 ) ) ) ).

% infiniteTr.coinduct
thf(fact_14_properPath_Ocoinduct,axiom,
    ! [A: $tType,X3: ( stream @ A ) > ( treeFI @ A ) > $o,X4: stream @ A,Xa: treeFI @ A] :
      ( ( X3 @ X4 @ Xa )
     => ( ! [X: stream @ A,Xa2: treeFI @ A] :
            ( ( X3 @ X @ Xa2 )
           => ? [As4: stream @ A,Tr8: treeFI @ A,Tr7: treeFI @ A] :
                ( ( X = As4 )
                & ( Xa2 = Tr8 )
                & ( ( shd @ A @ As4 )
                  = ( lab @ A @ Tr8 ) )
                & ( member2 @ ( treeFI @ A ) @ Tr7 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr8 ) ) )
                & ( ( X3 @ ( stl @ A @ As4 ) @ Tr7 )
                  | ( koenig1755522246erPath @ A @ ( stl @ A @ As4 ) @ Tr7 ) ) ) )
       => ( koenig1755522246erPath @ A @ X4 @ Xa ) ) ) ).

% properPath.coinduct
thf(fact_15_infiniteTr__strong__coind,axiom,
    ! [A: $tType,Phi: ( treeFI @ A ) > $o,Tr: treeFI @ A] :
      ( ( Phi @ Tr )
     => ( ! [Tr5: treeFI @ A] :
            ( ( Phi @ Tr5 )
           => ? [X2: treeFI @ A] :
                ( ( member2 @ ( treeFI @ A ) @ X2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr5 ) ) )
                & ( ( Phi @ X2 )
                  | ( koenig488553731niteTr @ A @ X2 ) ) ) )
       => ( koenig488553731niteTr @ A @ Tr ) ) ) ).

% infiniteTr_strong_coind
thf(fact_16_properPath__strong__coind,axiom,
    ! [A: $tType,Phi: ( stream @ A ) > ( treeFI @ A ) > $o,As: stream @ A,Tr: treeFI @ A] :
      ( ( Phi @ As @ Tr )
     => ( ! [As3: stream @ A,Tr5: treeFI @ A] :
            ( ( Phi @ As3 @ Tr5 )
           => ( ( shd @ A @ As3 )
              = ( lab @ A @ Tr5 ) ) )
       => ( ! [As3: stream @ A,Tr5: treeFI @ A] :
              ( ( Phi @ As3 @ Tr5 )
             => ? [X2: treeFI @ A] :
                  ( ( member2 @ ( treeFI @ A ) @ X2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr5 ) ) )
                  & ( ( Phi @ ( stl @ A @ As3 ) @ X2 )
                    | ( koenig1755522246erPath @ A @ ( stl @ A @ As3 ) @ X2 ) ) ) )
         => ( koenig1755522246erPath @ A @ As @ Tr ) ) ) ) ).

% properPath_strong_coind
thf(fact_17_treeFI_Oexpand,axiom,
    ! [A: $tType,TreeFI: treeFI @ A,TreeFI2: treeFI @ A] :
      ( ( ( ( lab @ A @ TreeFI )
          = ( lab @ A @ TreeFI2 ) )
        & ( ( sub @ A @ TreeFI )
          = ( sub @ A @ TreeFI2 ) ) )
     => ( TreeFI = TreeFI2 ) ) ).

% treeFI.expand
thf(fact_18_stream_Oexpand,axiom,
    ! [A: $tType,Stream: stream @ A,Stream2: stream @ A] :
      ( ( ( ( shd @ A @ Stream )
          = ( shd @ A @ Stream2 ) )
        & ( ( stl @ A @ Stream )
          = ( stl @ A @ Stream2 ) ) )
     => ( Stream = Stream2 ) ) ).

% stream.expand
thf(fact_19_stream_Ocoinduct,axiom,
    ! [A: $tType,R: ( stream @ A ) > ( stream @ A ) > $o,Stream: stream @ A,Stream2: stream @ A] :
      ( ( R @ Stream @ Stream2 )
     => ( ! [Stream3: stream @ A,Stream4: stream @ A] :
            ( ( R @ Stream3 @ Stream4 )
           => ( ( ( shd @ A @ Stream3 )
                = ( shd @ A @ Stream4 ) )
              & ( R @ ( stl @ A @ Stream3 ) @ ( stl @ A @ Stream4 ) ) ) )
       => ( Stream = Stream2 ) ) ) ).

% stream.coinduct
thf(fact_20_stream_Ocoinduct__strong,axiom,
    ! [A: $tType,R: ( stream @ A ) > ( stream @ A ) > $o,Stream: stream @ A,Stream2: stream @ A] :
      ( ( R @ Stream @ Stream2 )
     => ( ! [Stream3: stream @ A,Stream4: stream @ A] :
            ( ( R @ Stream3 @ Stream4 )
           => ( ( ( shd @ A @ Stream3 )
                = ( shd @ A @ Stream4 ) )
              & ( ( R @ ( stl @ A @ Stream3 ) @ ( stl @ A @ Stream4 ) )
                | ( ( stl @ A @ Stream3 )
                  = ( stl @ A @ Stream4 ) ) ) ) )
       => ( Stream = Stream2 ) ) ) ).

% stream.coinduct_strong
thf(fact_21_treeFI_Ocase__eq__if,axiom,
    ! [B: $tType,A: $tType] :
      ( ( case_treeFI @ A @ B )
      = ( ^ [F: A > ( list @ ( treeFI @ A ) ) > B,TreeFI3: treeFI @ A] : ( F @ ( lab @ A @ TreeFI3 ) @ ( sub @ A @ TreeFI3 ) ) ) ) ).

% treeFI.case_eq_if
thf(fact_22_stream_Ocase__eq__if,axiom,
    ! [B: $tType,A: $tType] :
      ( ( case_stream @ A @ B )
      = ( ^ [F: A > ( stream @ A ) > B,Stream5: stream @ A] : ( F @ ( shd @ A @ Stream5 ) @ ( stl @ A @ Stream5 ) ) ) ) ).

% stream.case_eq_if
thf(fact_23_treeFI_Ocollapse,axiom,
    ! [A: $tType,TreeFI: treeFI @ A] :
      ( ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) )
      = TreeFI ) ).

% treeFI.collapse
thf(fact_24_sdrop__while_Osimps,axiom,
    ! [A: $tType] :
      ( ( sdrop_while @ A )
      = ( ^ [P: A > $o,S: stream @ A] : ( if @ ( stream @ A ) @ ( P @ ( shd @ A @ S ) ) @ ( sdrop_while @ A @ P @ ( stl @ A @ S ) ) @ S ) ) ) ).

% sdrop_while.simps
thf(fact_25_konigPath_Osimps_I2_J,axiom,
    ! [A: $tType,T: treeFI @ A] :
      ( ( stl @ A @ ( koenig1103336060igPath @ A @ T ) )
      = ( koenig1103336060igPath @ A
        @ @+[Tr4: treeFI @ A] :
            ( ( member2 @ ( treeFI @ A ) @ Tr4 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ T ) ) )
            & ( koenig488553731niteTr @ A @ Tr4 ) ) ) ) ).

% konigPath.simps(2)
thf(fact_26_treeFI_Oset__sel_I2_J,axiom,
    ! [A: $tType,X4: treeFI @ A,A2: treeFI @ A,Xa: A] :
      ( ( member2 @ ( treeFI @ A ) @ X4 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ A2 ) ) )
     => ( ( member2 @ A @ Xa @ ( set_treeFI @ A @ X4 ) )
       => ( member2 @ A @ Xa @ ( set_treeFI @ A @ A2 ) ) ) ) ).

% treeFI.set_sel(2)
thf(fact_27_treeFI_Oexhaust__sel,axiom,
    ! [A: $tType,TreeFI: treeFI @ A] :
      ( TreeFI
      = ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) ) ).

% treeFI.exhaust_sel
thf(fact_28_stream_Ocollapse,axiom,
    ! [A: $tType,Stream: stream @ A] :
      ( ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) )
      = Stream ) ).

% stream.collapse
thf(fact_29_stream_Oinject,axiom,
    ! [A: $tType,X1: A,X22: stream @ A,Y1: A,Y2: stream @ A] :
      ( ( ( sCons @ A @ X1 @ X22 )
        = ( sCons @ A @ Y1 @ Y2 ) )
      = ( ( X1 = Y1 )
        & ( X22 = Y2 ) ) ) ).

% stream.inject
thf(fact_30_treeFI_Oinject,axiom,
    ! [A: $tType,X1: A,X22: list @ ( treeFI @ A ),Y1: A,Y2: list @ ( treeFI @ A )] :
      ( ( ( tree @ A @ X1 @ X22 )
        = ( tree @ A @ Y1 @ Y2 ) )
      = ( ( X1 = Y1 )
        & ( X22 = Y2 ) ) ) ).

% treeFI.inject
thf(fact_31_shd__def,axiom,
    ! [A: $tType] :
      ( ( shd @ A )
      = ( case_stream @ A @ A
        @ ^ [X12: A,X23: stream @ A] : X12 ) ) ).

% shd_def
thf(fact_32_stl__def,axiom,
    ! [A: $tType] :
      ( ( stl @ A )
      = ( case_stream @ A @ ( stream @ A )
        @ ^ [X12: A,X23: stream @ A] : X23 ) ) ).

% stl_def
thf(fact_33_lab__def,axiom,
    ! [A: $tType] :
      ( ( lab @ A )
      = ( case_treeFI @ A @ A
        @ ^ [X12: A,X23: list @ ( treeFI @ A )] : X12 ) ) ).

% lab_def
thf(fact_34_treeFI_Osub__def,axiom,
    ! [A: $tType] :
      ( ( sub @ A )
      = ( case_treeFI @ A @ ( list @ ( treeFI @ A ) )
        @ ^ [X12: A,X23: list @ ( treeFI @ A )] : X23 ) ) ).

% treeFI.sub_def
thf(fact_35_treeFI_Ocase__distrib,axiom,
    ! [B: $tType,C: $tType,A: $tType,H: B > C,F2: A > ( list @ ( treeFI @ A ) ) > B,TreeFI: treeFI @ A] :
      ( ( H @ ( case_treeFI @ A @ B @ F2 @ TreeFI ) )
      = ( case_treeFI @ A @ C
        @ ^ [X12: A,X23: list @ ( treeFI @ A )] : ( H @ ( F2 @ X12 @ X23 ) )
        @ TreeFI ) ) ).

% treeFI.case_distrib
thf(fact_36_stream_Ocase__distrib,axiom,
    ! [B: $tType,C: $tType,A: $tType,H: B > C,F2: A > ( stream @ A ) > B,Stream: stream @ A] :
      ( ( H @ ( case_stream @ A @ B @ F2 @ Stream ) )
      = ( case_stream @ A @ C
        @ ^ [X12: A,X23: stream @ A] : ( H @ ( F2 @ X12 @ X23 ) )
        @ Stream ) ) ).

% stream.case_distrib
thf(fact_37_sdrop__while__SCons,axiom,
    ! [A: $tType,P2: A > $o,A2: A,S2: stream @ A] :
      ( ( ( P2 @ A2 )
       => ( ( sdrop_while @ A @ P2 @ ( sCons @ A @ A2 @ S2 ) )
          = ( sdrop_while @ A @ P2 @ S2 ) ) )
      & ( ~ ( P2 @ A2 )
       => ( ( sdrop_while @ A @ P2 @ ( sCons @ A @ A2 @ S2 ) )
          = ( sCons @ A @ A2 @ S2 ) ) ) ) ).

% sdrop_while_SCons
thf(fact_38_treeFI_Oexhaust,axiom,
    ! [A: $tType,Y: treeFI @ A] :
      ~ ! [X13: A,X24: list @ ( treeFI @ A )] :
          ( Y
         != ( tree @ A @ X13 @ X24 ) ) ).

% treeFI.exhaust
thf(fact_39_stream_Oexhaust,axiom,
    ! [A: $tType,Y: stream @ A] :
      ~ ! [X13: A,X24: stream @ A] :
          ( Y
         != ( sCons @ A @ X13 @ X24 ) ) ).

% stream.exhaust
thf(fact_40_treeFI_Ocase,axiom,
    ! [B: $tType,A: $tType,F2: A > ( list @ ( treeFI @ A ) ) > B,X1: A,X22: list @ ( treeFI @ A )] :
      ( ( case_treeFI @ A @ B @ F2 @ ( tree @ A @ X1 @ X22 ) )
      = ( F2 @ X1 @ X22 ) ) ).

% treeFI.case
thf(fact_41_stream_Ocase,axiom,
    ! [B: $tType,A: $tType,F2: A > ( stream @ A ) > B,X1: A,X22: stream @ A] :
      ( ( case_stream @ A @ B @ F2 @ ( sCons @ A @ X1 @ X22 ) )
      = ( F2 @ X1 @ X22 ) ) ).

% stream.case
thf(fact_42_treeFI_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A22: list @ ( treeFI @ A )] : ( member2 @ A @ A1 @ ( set_treeFI @ A @ ( tree @ A @ A1 @ A22 ) ) ) ).

% treeFI.set_intros(1)
thf(fact_43_treeFI_Oset__induct,axiom,
    ! [A: $tType,X4: A,A2: treeFI @ A,P2: A > ( treeFI @ A ) > $o] :
      ( ( member2 @ A @ X4 @ ( set_treeFI @ A @ A2 ) )
     => ( ! [Z1: A,Z2: list @ ( treeFI @ A )] : ( P2 @ Z1 @ ( tree @ A @ Z1 @ Z2 ) )
       => ( ! [Z1: A,Z2: list @ ( treeFI @ A ),Xa2: treeFI @ A,Xb: A] :
              ( ( member2 @ ( treeFI @ A ) @ Xa2 @ ( set2 @ ( treeFI @ A ) @ Z2 ) )
             => ( ( member2 @ A @ Xb @ ( set_treeFI @ A @ Xa2 ) )
               => ( ( P2 @ Xb @ Xa2 )
                 => ( P2 @ Xb @ ( tree @ A @ Z1 @ Z2 ) ) ) ) )
         => ( P2 @ X4 @ A2 ) ) ) ) ).

% treeFI.set_induct
thf(fact_44_treeFI_Oset__cases,axiom,
    ! [A: $tType,E2: A,A2: treeFI @ A] :
      ( ( member2 @ A @ E2 @ ( set_treeFI @ A @ A2 ) )
     => ( ! [Z2: list @ ( treeFI @ A )] :
            ( A2
           != ( tree @ A @ E2 @ Z2 ) )
       => ~ ! [Z1: A,Z2: list @ ( treeFI @ A )] :
              ( ( A2
                = ( tree @ A @ Z1 @ Z2 ) )
             => ! [X: treeFI @ A] :
                  ( ( member2 @ ( treeFI @ A ) @ X @ ( set2 @ ( treeFI @ A ) @ Z2 ) )
                 => ~ ( member2 @ A @ E2 @ ( set_treeFI @ A @ X ) ) ) ) ) ) ).

% treeFI.set_cases
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P2: A > $o] :
      ( ( member2 @ A @ A2 @ ( collect @ A @ P2 ) )
      = ( P2 @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X5: A] : ( member2 @ A @ X5 @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P2: A > $o,Q: A > $o] :
      ( ! [X: A] :
          ( ( P2 @ X )
          = ( Q @ X ) )
     => ( ( collect @ A @ P2 )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F2: A > B,G: A > B] :
      ( ! [X: A] :
          ( ( F2 @ X )
          = ( G @ X ) )
     => ( F2 = G ) ) ).

% ext
thf(fact_49_treeFI_Oset__intros_I2_J,axiom,
    ! [A: $tType,X4: treeFI @ A,A22: list @ ( treeFI @ A ),Xa: A,A1: A] :
      ( ( member2 @ ( treeFI @ A ) @ X4 @ ( set2 @ ( treeFI @ A ) @ A22 ) )
     => ( ( member2 @ A @ Xa @ ( set_treeFI @ A @ X4 ) )
       => ( member2 @ A @ Xa @ ( set_treeFI @ A @ ( tree @ A @ A1 @ A22 ) ) ) ) ) ).

% treeFI.set_intros(2)
thf(fact_50_stream_Osel_I2_J,axiom,
    ! [A: $tType,X1: A,X22: stream @ A] :
      ( ( stl @ A @ ( sCons @ A @ X1 @ X22 ) )
      = X22 ) ).

% stream.sel(2)
thf(fact_51_stream_Osel_I1_J,axiom,
    ! [A: $tType,X1: A,X22: stream @ A] :
      ( ( shd @ A @ ( sCons @ A @ X1 @ X22 ) )
      = X1 ) ).

% stream.sel(1)
thf(fact_52_treeFI_Osel_I2_J,axiom,
    ! [A: $tType,X1: A,X22: list @ ( treeFI @ A )] :
      ( ( sub @ A @ ( tree @ A @ X1 @ X22 ) )
      = X22 ) ).

% treeFI.sel(2)
thf(fact_53_treeFI_Osel_I1_J,axiom,
    ! [A: $tType,X1: A,X22: list @ ( treeFI @ A )] :
      ( ( lab @ A @ ( tree @ A @ X1 @ X22 ) )
      = X1 ) ).

% treeFI.sel(1)
thf(fact_54_treeFI_Oset__sel_I1_J,axiom,
    ! [A: $tType,A2: treeFI @ A] : ( member2 @ A @ ( lab @ A @ A2 ) @ ( set_treeFI @ A @ A2 ) ) ).

% treeFI.set_sel(1)
thf(fact_55_stream_Osplit__sel__asm,axiom,
    ! [B: $tType,A: $tType,P2: B > $o,F2: A > ( stream @ A ) > B,Stream: stream @ A] :
      ( ( P2 @ ( case_stream @ A @ B @ F2 @ Stream ) )
      = ( ~ ( ( Stream
              = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) )
            & ~ ( P2 @ ( F2 @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ) ) ) ).

% stream.split_sel_asm
thf(fact_56_stream_Osplit__sel,axiom,
    ! [B: $tType,A: $tType,P2: B > $o,F2: A > ( stream @ A ) > B,Stream: stream @ A] :
      ( ( P2 @ ( case_stream @ A @ B @ F2 @ Stream ) )
      = ( ( Stream
          = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) )
       => ( P2 @ ( F2 @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ) ) ).

% stream.split_sel
thf(fact_57_treeFI_Osplit__sel__asm,axiom,
    ! [B: $tType,A: $tType,P2: B > $o,F2: A > ( list @ ( treeFI @ A ) ) > B,TreeFI: treeFI @ A] :
      ( ( P2 @ ( case_treeFI @ A @ B @ F2 @ TreeFI ) )
      = ( ~ ( ( TreeFI
              = ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) )
            & ~ ( P2 @ ( F2 @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) ) ) ) ) ).

% treeFI.split_sel_asm
thf(fact_58_treeFI_Osplit__sel,axiom,
    ! [B: $tType,A: $tType,P2: B > $o,F2: A > ( list @ ( treeFI @ A ) ) > B,TreeFI: treeFI @ A] :
      ( ( P2 @ ( case_treeFI @ A @ B @ F2 @ TreeFI ) )
      = ( ( TreeFI
          = ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) )
       => ( P2 @ ( F2 @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) ) ) ) ).

% treeFI.split_sel
thf(fact_59_konigPath_Ocode,axiom,
    ! [A: $tType] :
      ( ( koenig1103336060igPath @ A )
      = ( ^ [T2: treeFI @ A] :
            ( sCons @ A @ ( lab @ A @ T2 )
            @ ( koenig1103336060igPath @ A
              @ @+[Tr4: treeFI @ A] :
                  ( ( member2 @ ( treeFI @ A ) @ Tr4 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ T2 ) ) )
                  & ( koenig488553731niteTr @ A @ Tr4 ) ) ) ) ) ) ).

% konigPath.code
thf(fact_60_stream_Oexhaust__sel,axiom,
    ! [A: $tType,Stream: stream @ A] :
      ( Stream
      = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ).

% stream.exhaust_sel
thf(fact_61_some__sym__eq__trivial,axiom,
    ! [A: $tType,X4: A] :
      ( ( ^ [P3: A > $o] :
          @+[X6: A] : ( P3 @ X6 )
        @ ( ^ [Y3: A,Z: A] : ( Y3 = Z )
          @ X4 ) )
      = X4 ) ).

% some_sym_eq_trivial
thf(fact_62_some__eq__trivial,axiom,
    ! [A: $tType,X4: A] :
      ( ( @+[Y4: A] : ( Y4 = X4 ) )
      = X4 ) ).

% some_eq_trivial
thf(fact_63_some__equality,axiom,
    ! [A: $tType,P2: A > $o,A2: A] :
      ( ( P2 @ A2 )
     => ( ! [X: A] :
            ( ( P2 @ X )
           => ( X = A2 ) )
       => ( ( ^ [P3: A > $o] :
              @+[X6: A] : ( P3 @ X6 )
            @ P2 )
          = A2 ) ) ) ).

% some_equality
thf(fact_64_smember__code,axiom,
    ! [A: $tType,X4: A,Y: A,S2: stream @ A] :
      ( ( smember @ A @ X4 @ ( sCons @ A @ Y @ S2 ) )
      = ( ( X4 != Y )
       => ( smember @ A @ X4 @ S2 ) ) ) ).

% smember_code
thf(fact_65_sinterleave_Ocode,axiom,
    ! [A: $tType] :
      ( ( sinterleave @ A )
      = ( ^ [S1: stream @ A,S22: stream @ A] : ( sCons @ A @ ( shd @ A @ S1 ) @ ( sinterleave @ A @ S22 @ ( stl @ A @ S1 ) ) ) ) ) ).

% sinterleave.code
thf(fact_66_some1__equality,axiom,
    ! [A: $tType,P2: A > $o,A2: A] :
      ( ? [X2: A] :
          ( ( P2 @ X2 )
          & ! [Y5: A] :
              ( ( P2 @ Y5 )
             => ( Y5 = X2 ) ) )
     => ( ( P2 @ A2 )
       => ( ( ^ [P3: A > $o] :
              @+[X6: A] : ( P3 @ X6 )
            @ P2 )
          = A2 ) ) ) ).

% some1_equality
thf(fact_67_some__eq__ex,axiom,
    ! [A: $tType,P2: A > $o] :
      ( ( P2
        @ ( ^ [P3: A > $o] :
            @+[X6: A] : ( P3 @ X6 )
          @ P2 ) )
      = ( ^ [P3: A > $o] :
          ? [X6: A] : ( P3 @ X6 )
        @ P2 ) ) ).

% some_eq_ex
thf(fact_68_someI2__bex,axiom,
    ! [A: $tType,A4: set @ A,P2: A > $o,Q: A > $o] :
      ( ? [X2: A] :
          ( ( member2 @ A @ X2 @ A4 )
          & ( P2 @ X2 ) )
     => ( ! [X: A] :
            ( ( ( member2 @ A @ X @ A4 )
              & ( P2 @ X ) )
           => ( Q @ X ) )
       => ( Q
          @ @+[X5: A] :
              ( ( member2 @ A @ X5 @ A4 )
              & ( P2 @ X5 ) ) ) ) ) ).

% someI2_bex
thf(fact_69_someI2__ex,axiom,
    ! [A: $tType,P2: A > $o,Q: A > $o] :
      ( ? [X14: A] : ( P2 @ X14 )
     => ( ! [X: A] :
            ( ( P2 @ X )
           => ( Q @ X ) )
       => ( Q
          @ ( ^ [P3: A > $o] :
              @+[X6: A] : ( P3 @ X6 )
            @ P2 ) ) ) ) ).

% someI2_ex
thf(fact_70_sinterleave_Osimps_I2_J,axiom,
    ! [A: $tType,S12: stream @ A,S23: stream @ A] :
      ( ( stl @ A @ ( sinterleave @ A @ S12 @ S23 ) )
      = ( sinterleave @ A @ S23 @ ( stl @ A @ S12 ) ) ) ).

% sinterleave.simps(2)
thf(fact_71_sinterleave_Osimps_I1_J,axiom,
    ! [A: $tType,S12: stream @ A,S23: stream @ A] :
      ( ( shd @ A @ ( sinterleave @ A @ S12 @ S23 ) )
      = ( shd @ A @ S12 ) ) ).

% sinterleave.simps(1)
thf(fact_72_sinterleave__code,axiom,
    ! [A: $tType,X4: A,S12: stream @ A,S23: stream @ A] :
      ( ( sinterleave @ A @ ( sCons @ A @ X4 @ S12 ) @ S23 )
      = ( sCons @ A @ X4 @ ( sinterleave @ A @ S23 @ S12 ) ) ) ).

% sinterleave_code
thf(fact_73_someI,axiom,
    ! [A: $tType,P2: A > $o,X4: A] :
      ( ( P2 @ X4 )
     => ( P2
        @ ( ^ [P3: A > $o] :
            @+[X6: A] : ( P3 @ X6 )
          @ P2 ) ) ) ).

% someI
thf(fact_74_tfl__some,axiom,
    ! [A: $tType,P4: A > $o,X2: A] :
      ( ( P4 @ X2 )
     => ( P4
        @ ( ^ [P3: A > $o] :
            @+[X6: A] : ( P3 @ X6 )
          @ P4 ) ) ) ).

% tfl_some
thf(fact_75_someI2,axiom,
    ! [A: $tType,P2: A > $o,A2: A,Q: A > $o] :
      ( ( P2 @ A2 )
     => ( ! [X: A] :
            ( ( P2 @ X )
           => ( Q @ X ) )
       => ( Q
          @ ( ^ [P3: A > $o] :
              @+[X6: A] : ( P3 @ X6 )
            @ P2 ) ) ) ) ).

% someI2
thf(fact_76_someI__ex,axiom,
    ! [A: $tType,P2: A > $o] :
      ( ? [X14: A] : ( P2 @ X14 )
     => ( P2
        @ ( ^ [P3: A > $o] :
            @+[X6: A] : ( P3 @ X6 )
          @ P2 ) ) ) ).

% someI_ex
thf(fact_77_smap2_Ocode,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( smap2 @ A @ B @ C )
      = ( ^ [F: A > B > C,S1: stream @ A,S22: stream @ B] : ( sCons @ C @ ( F @ ( shd @ A @ S1 ) @ ( shd @ B @ S22 ) ) @ ( smap2 @ A @ B @ C @ F @ ( stl @ A @ S1 ) @ ( stl @ B @ S22 ) ) ) ) ) ).

% smap2.code
thf(fact_78_Nitpick_OEps__psimp,axiom,
    ! [A: $tType,P2: A > $o,X4: A,Y: A] :
      ( ( P2 @ X4 )
     => ( ~ ( P2 @ Y )
       => ( ( ( ^ [P3: A > $o] :
                @+[X6: A] : ( P3 @ X6 )
              @ P2 )
            = Y )
         => ( ( ^ [P3: A > $o] :
                @+[X6: A] : ( P3 @ X6 )
              @ P2 )
            = X4 ) ) ) ) ).

% Nitpick.Eps_psimp
thf(fact_79_smap__ctr,axiom,
    ! [B: $tType,A: $tType,F2: B > A,S2: stream @ B,X4: A,S3: stream @ A] :
      ( ( ( smap @ B @ A @ F2 @ S2 )
        = ( sCons @ A @ X4 @ S3 ) )
      = ( ( ( F2 @ ( shd @ B @ S2 ) )
          = X4 )
        & ( ( smap @ B @ A @ F2 @ ( stl @ B @ S2 ) )
          = S3 ) ) ) ).

% smap_ctr
thf(fact_80_trev_Osimps_I1_J,axiom,
    ! [A: $tType,T: treeFI @ A] :
      ( ( lab @ A @ ( trev @ A @ T ) )
      = ( lab @ A @ T ) ) ).

% trev.simps(1)
thf(fact_81_sfilter_Ocode,axiom,
    ! [A: $tType] :
      ( ( sfilter @ A )
      = ( ^ [P: A > $o,S: stream @ A] : ( sCons @ A @ ( shd @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P ) @ S ) ) @ ( sfilter @ A @ P @ ( stl @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P ) @ S ) ) ) ) ) ) ).

% sfilter.code
thf(fact_82_streamsE,axiom,
    ! [A: $tType,S2: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A4 ) )
     => ~ ( ( member2 @ A @ ( shd @ A @ S2 ) @ A4 )
         => ~ ( member2 @ ( stream @ A ) @ ( stl @ A @ S2 ) @ ( streams @ A @ A4 ) ) ) ) ).

% streamsE
thf(fact_83_in__streams,axiom,
    ! [A: $tType,S2: stream @ A,S4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ ( stl @ A @ S2 ) @ ( streams @ A @ S4 ) )
     => ( ( member2 @ A @ ( shd @ A @ S2 ) @ S4 )
       => ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ S4 ) ) ) ) ).

% in_streams
thf(fact_84_stream_Omap__sel_I2_J,axiom,
    ! [B: $tType,A: $tType,F2: A > B,A2: stream @ A] :
      ( ( stl @ B @ ( smap @ A @ B @ F2 @ A2 ) )
      = ( smap @ A @ B @ F2 @ ( stl @ A @ A2 ) ) ) ).

% stream.map_sel(2)
thf(fact_85_stream_Omap__sel_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: A > B,A2: stream @ A] :
      ( ( shd @ B @ ( smap @ A @ B @ F2 @ A2 ) )
      = ( F2 @ ( shd @ A @ A2 ) ) ) ).

% stream.map_sel(1)
thf(fact_86_smap__smap2,axiom,
    ! [C: $tType,A: $tType,B: $tType,D: $tType,F2: B > A,G: C > D > B,S12: stream @ C,S23: stream @ D] :
      ( ( smap @ B @ A @ F2 @ ( smap2 @ C @ D @ B @ G @ S12 @ S23 ) )
      = ( smap2 @ C @ D @ A
        @ ^ [X5: C,Y4: D] : ( F2 @ ( G @ X5 @ Y4 ) )
        @ S12
        @ S23 ) ) ).

% smap_smap2
thf(fact_87_trev__trev,axiom,
    ! [A: $tType,Tr: treeFI @ A] :
      ( ( trev @ A @ ( trev @ A @ Tr ) )
      = Tr ) ).

% trev_trev
thf(fact_88_stream_Omap__ident,axiom,
    ! [A: $tType,T: stream @ A] :
      ( ( smap @ A @ A
        @ ^ [X5: A] : X5
        @ T )
      = T ) ).

% stream.map_ident
thf(fact_89_smap__streams,axiom,
    ! [A: $tType,B: $tType,S2: stream @ A,A4: set @ A,F2: A > B,B2: set @ B] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A4 ) )
     => ( ! [X: A] :
            ( ( member2 @ A @ X @ A4 )
           => ( member2 @ B @ ( F2 @ X ) @ B2 ) )
       => ( member2 @ ( stream @ B ) @ ( smap @ A @ B @ F2 @ S2 ) @ ( streams @ B @ B2 ) ) ) ) ).

% smap_streams
thf(fact_90_stream_Omap__comp,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: B > C,F2: A > B,V: stream @ A] :
      ( ( smap @ B @ C @ G @ ( smap @ A @ B @ F2 @ V ) )
      = ( smap @ A @ C @ ( comp @ B @ C @ A @ G @ F2 ) @ V ) ) ).

% stream.map_comp
thf(fact_91_stream_Omap,axiom,
    ! [B: $tType,A: $tType,F2: A > B,X1: A,X22: stream @ A] :
      ( ( smap @ A @ B @ F2 @ ( sCons @ A @ X1 @ X22 ) )
      = ( sCons @ B @ ( F2 @ X1 ) @ ( smap @ A @ B @ F2 @ X22 ) ) ) ).

% stream.map
thf(fact_92_sfilter_Osimps_I2_J,axiom,
    ! [A: $tType,P2: A > $o,S2: stream @ A] :
      ( ( stl @ A @ ( sfilter @ A @ P2 @ S2 ) )
      = ( sfilter @ A @ P2 @ ( stl @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P2 ) @ S2 ) ) ) ) ).

% sfilter.simps(2)
thf(fact_93_sfilter_Osimps_I1_J,axiom,
    ! [A: $tType,P2: A > $o,S2: stream @ A] :
      ( ( shd @ A @ ( sfilter @ A @ P2 @ S2 ) )
      = ( shd @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P2 ) @ S2 ) ) ) ).

% sfilter.simps(1)
thf(fact_94_streams__stl,axiom,
    ! [A: $tType,S2: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A4 ) )
     => ( member2 @ ( stream @ A ) @ ( stl @ A @ S2 ) @ ( streams @ A @ A4 ) ) ) ).

% streams_stl
thf(fact_95_streams__shd,axiom,
    ! [A: $tType,S2: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A4 ) )
     => ( member2 @ A @ ( shd @ A @ S2 ) @ A4 ) ) ).

% streams_shd
thf(fact_96_streams_Ocoinduct,axiom,
    ! [A: $tType,X3: ( stream @ A ) > $o,X4: stream @ A,A4: set @ A] :
      ( ( X3 @ X4 )
     => ( ! [X: stream @ A] :
            ( ( X3 @ X )
           => ? [A5: A,S5: stream @ A] :
                ( ( X
                  = ( sCons @ A @ A5 @ S5 ) )
                & ( member2 @ A @ A5 @ A4 )
                & ( ( X3 @ S5 )
                  | ( member2 @ ( stream @ A ) @ S5 @ ( streams @ A @ A4 ) ) ) ) )
       => ( member2 @ ( stream @ A ) @ X4 @ ( streams @ A @ A4 ) ) ) ) ).

% streams.coinduct
thf(fact_97_streams__Stream,axiom,
    ! [A: $tType,X4: A,S2: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ ( sCons @ A @ X4 @ S2 ) @ ( streams @ A @ A4 ) )
      = ( ( member2 @ A @ X4 @ A4 )
        & ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ A4 ) ) ) ) ).

% streams_Stream
thf(fact_98_streams_Osimps,axiom,
    ! [A: $tType,A2: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ A2 @ ( streams @ A @ A4 ) )
      = ( ? [A3: A,S: stream @ A] :
            ( ( A2
              = ( sCons @ A @ A3 @ S ) )
            & ( member2 @ A @ A3 @ A4 )
            & ( member2 @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) ) ) ) ) ).

% streams.simps
thf(fact_99_streams_Ocases,axiom,
    ! [A: $tType,A2: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ A2 @ ( streams @ A @ A4 ) )
     => ~ ! [A6: A,S6: stream @ A] :
            ( ( A2
              = ( sCons @ A @ A6 @ S6 ) )
           => ( ( member2 @ A @ A6 @ A4 )
             => ~ ( member2 @ ( stream @ A ) @ S6 @ ( streams @ A @ A4 ) ) ) ) ) ).

% streams.cases
thf(fact_100_smap2_Osimps_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,F2: A > B > C,S12: stream @ A,S23: stream @ B] :
      ( ( stl @ C @ ( smap2 @ A @ B @ C @ F2 @ S12 @ S23 ) )
      = ( smap2 @ A @ B @ C @ F2 @ ( stl @ A @ S12 ) @ ( stl @ B @ S23 ) ) ) ).

% smap2.simps(2)
thf(fact_101_smap2_Osimps_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,F2: A > B > C,S12: stream @ A,S23: stream @ B] :
      ( ( shd @ C @ ( smap2 @ A @ B @ C @ F2 @ S12 @ S23 ) )
      = ( F2 @ ( shd @ A @ S12 ) @ ( shd @ B @ S23 ) ) ) ).

% smap2.simps(1)
thf(fact_102_smap2__unfold,axiom,
    ! [B: $tType,A: $tType,C: $tType,F2: B > C > A,A2: B,S12: stream @ B,B3: C,S23: stream @ C] :
      ( ( smap2 @ B @ C @ A @ F2 @ ( sCons @ B @ A2 @ S12 ) @ ( sCons @ C @ B3 @ S23 ) )
      = ( sCons @ A @ ( F2 @ A2 @ B3 ) @ ( smap2 @ B @ C @ A @ F2 @ S12 @ S23 ) ) ) ).

% smap2_unfold
thf(fact_103_sfilter__Stream,axiom,
    ! [A: $tType,P2: A > $o,X4: A,S2: stream @ A] :
      ( ( ( P2 @ X4 )
       => ( ( sfilter @ A @ P2 @ ( sCons @ A @ X4 @ S2 ) )
          = ( sCons @ A @ X4 @ ( sfilter @ A @ P2 @ S2 ) ) ) )
      & ( ~ ( P2 @ X4 )
       => ( ( sfilter @ A @ P2 @ ( sCons @ A @ X4 @ S2 ) )
          = ( sfilter @ A @ P2 @ S2 ) ) ) ) ).

% sfilter_Stream
thf(fact_104_comp__apply,axiom,
    ! [C: $tType,A: $tType,B: $tType] :
      ( ( comp @ B @ A @ C )
      = ( ^ [F: B > A,G2: C > B,X5: C] : ( F @ ( G2 @ X5 ) ) ) ) ).

% comp_apply
thf(fact_105_conj__comp__iff,axiom,
    ! [B: $tType,A: $tType,P2: B > $o,Q: B > $o,G: A > B] :
      ( ( comp @ B @ $o @ A
        @ ^ [X5: B] :
            ( ( P2 @ X5 )
            & ( Q @ X5 ) )
        @ G )
      = ( ^ [X5: A] :
            ( ( comp @ B @ $o @ A @ P2 @ G @ X5 )
            & ( comp @ B @ $o @ A @ Q @ G @ X5 ) ) ) ) ).

% conj_comp_iff
thf(fact_106_K__record__comp,axiom,
    ! [C: $tType,B: $tType,A: $tType,C2: B,F2: A > C] :
      ( ( comp @ C @ B @ A
        @ ^ [X5: C] : C2
        @ F2 )
      = ( ^ [X5: A] : C2 ) ) ).

% K_record_comp
thf(fact_107_fun_Omap__ident,axiom,
    ! [A: $tType,D: $tType,T: D > A] :
      ( ( comp @ A @ A @ D
        @ ^ [X5: A] : X5
        @ T )
      = T ) ).

% fun.map_ident
thf(fact_108_stream_Omap__o__corec,axiom,
    ! [A: $tType,B: $tType,C: $tType,F2: A > B,G: C > A,Ga: C > $o,Gb: C > ( stream @ A ),Gc: C > C] :
      ( ( comp @ ( stream @ A ) @ ( stream @ B ) @ C @ ( smap @ A @ B @ F2 ) @ ( corec_stream @ C @ A @ G @ Ga @ Gb @ Gc ) )
      = ( corec_stream @ C @ B @ ( comp @ A @ B @ C @ F2 @ G ) @ Ga @ ( comp @ ( stream @ A ) @ ( stream @ B ) @ C @ ( smap @ A @ B @ F2 ) @ Gb ) @ Gc ) ) ).

% stream.map_o_corec
thf(fact_109_stream_Opred__map,axiom,
    ! [B: $tType,A: $tType,Q: B > $o,F2: A > B,X4: stream @ A] :
      ( ( pred_stream @ B @ Q @ ( smap @ A @ B @ F2 @ X4 ) )
      = ( pred_stream @ A @ ( comp @ B @ $o @ A @ Q @ F2 ) @ X4 ) ) ).

% stream.pred_map
thf(fact_110_stream_Opred__inject,axiom,
    ! [A: $tType,P2: A > $o,A2: A,Aa2: stream @ A] :
      ( ( pred_stream @ A @ P2 @ ( sCons @ A @ A2 @ Aa2 ) )
      = ( ( P2 @ A2 )
        & ( pred_stream @ A @ P2 @ Aa2 ) ) ) ).

% stream.pred_inject
thf(fact_111_stream_Opred__True,axiom,
    ! [A: $tType] :
      ( ( pred_stream @ A
        @ ^ [Uu: A] : $true )
      = ( ^ [Uu: stream @ A] : $true ) ) ).

% stream.pred_True
thf(fact_112_stream_Ocorec__disc,axiom,
    ! [A: $tType,C: $tType] :
      ( ( corec_stream @ C @ A )
      = ( corec_stream @ C @ A ) ) ).

% stream.corec_disc
thf(fact_113_stream_Ocorec__sel_I2_J,axiom,
    ! [A: $tType,C: $tType,Q2: C > $o,A2: C,G1: C > A,G21: C > ( stream @ A ),G22: C > C] :
      ( ( ( Q2 @ A2 )
       => ( ( stl @ A @ ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ A2 ) )
          = ( G21 @ A2 ) ) )
      & ( ~ ( Q2 @ A2 )
       => ( ( stl @ A @ ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ A2 ) )
          = ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ ( G22 @ A2 ) ) ) ) ) ).

% stream.corec_sel(2)
thf(fact_114_stream_Ocorec__sel_I1_J,axiom,
    ! [A: $tType,C: $tType,G1: C > A,Q2: C > $o,G21: C > ( stream @ A ),G22: C > C,A2: C] :
      ( ( shd @ A @ ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ A2 ) )
      = ( G1 @ A2 ) ) ).

% stream.corec_sel(1)
thf(fact_115_stream_Ocorec__code,axiom,
    ! [A: $tType,C: $tType] :
      ( ( corec_stream @ C @ A )
      = ( ^ [G12: C > A,Q22: C > $o,G212: C > ( stream @ A ),G222: C > C,A3: C] : ( sCons @ A @ ( G12 @ A3 ) @ ( if @ ( stream @ A ) @ ( Q22 @ A3 ) @ ( G212 @ A3 ) @ ( corec_stream @ C @ A @ G12 @ Q22 @ G212 @ G222 @ ( G222 @ A3 ) ) ) ) ) ) ).

% stream.corec_code
thf(fact_116_stream_Omap__cong__pred,axiom,
    ! [B: $tType,A: $tType,X4: stream @ A,Ya: stream @ A,F2: A > B,G: A > B] :
      ( ( X4 = Ya )
     => ( ( pred_stream @ A
          @ ^ [Z3: A] :
              ( ( F2 @ Z3 )
              = ( G @ Z3 ) )
          @ Ya )
       => ( ( smap @ A @ B @ F2 @ X4 )
          = ( smap @ A @ B @ G @ Ya ) ) ) ) ).

% stream.map_cong_pred
thf(fact_117_comp__def,axiom,
    ! [A: $tType,C: $tType,B: $tType] :
      ( ( comp @ B @ C @ A )
      = ( ^ [F: B > C,G2: A > B,X5: A] : ( F @ ( G2 @ X5 ) ) ) ) ).

% comp_def
thf(fact_118_comp__assoc,axiom,
    ! [B: $tType,D: $tType,C: $tType,A: $tType,F2: D > B,G: C > D,H: A > C] :
      ( ( comp @ C @ B @ A @ ( comp @ D @ B @ C @ F2 @ G ) @ H )
      = ( comp @ D @ B @ A @ F2 @ ( comp @ C @ D @ A @ G @ H ) ) ) ).

% comp_assoc
thf(fact_119_comp__eq__dest,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,A2: C > B,B3: A > C,C2: D > B,D2: A > D,V: A] :
      ( ( ( comp @ C @ B @ A @ A2 @ B3 )
        = ( comp @ D @ B @ A @ C2 @ D2 ) )
     => ( ( A2 @ ( B3 @ V ) )
        = ( C2 @ ( D2 @ V ) ) ) ) ).

% comp_eq_dest
thf(fact_120_comp__eq__elim,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,A2: C > B,B3: A > C,C2: D > B,D2: A > D] :
      ( ( ( comp @ C @ B @ A @ A2 @ B3 )
        = ( comp @ D @ B @ A @ C2 @ D2 ) )
     => ! [V2: A] :
          ( ( A2 @ ( B3 @ V2 ) )
          = ( C2 @ ( D2 @ V2 ) ) ) ) ).

% comp_eq_elim
thf(fact_121_comp__eq__dest__lhs,axiom,
    ! [C: $tType,B: $tType,A: $tType,A2: C > B,B3: A > C,C2: A > B,V: A] :
      ( ( ( comp @ C @ B @ A @ A2 @ B3 )
        = C2 )
     => ( ( A2 @ ( B3 @ V ) )
        = ( C2 @ V ) ) ) ).

% comp_eq_dest_lhs
thf(fact_122_fun_Omap__comp,axiom,
    ! [B: $tType,C: $tType,A: $tType,D: $tType,G: B > C,F2: A > B,V: D > A] :
      ( ( comp @ B @ C @ D @ G @ ( comp @ A @ B @ D @ F2 @ V ) )
      = ( comp @ A @ C @ D @ ( comp @ B @ C @ A @ G @ F2 ) @ V ) ) ).

% fun.map_comp
thf(fact_123_type__copy__map__cong0,axiom,
    ! [B: $tType,D: $tType,E: $tType,A: $tType,C: $tType,M: B > A,G: C > B,X4: C,N: D > A,H: C > D,F2: A > E] :
      ( ( ( M @ ( G @ X4 ) )
        = ( N @ ( H @ X4 ) ) )
     => ( ( comp @ B @ E @ C @ ( comp @ A @ E @ B @ F2 @ M ) @ G @ X4 )
        = ( comp @ D @ E @ C @ ( comp @ A @ E @ D @ F2 @ N ) @ H @ X4 ) ) ) ).

% type_copy_map_cong0
thf(fact_124_fun_Opred__map,axiom,
    ! [B: $tType,A: $tType,D: $tType,Q: B > $o,F2: A > B,X4: D > A] :
      ( ( basic_pred_fun @ D @ B
        @ ^ [Uu: D] : $true
        @ Q
        @ ( comp @ A @ B @ D @ F2 @ X4 ) )
      = ( basic_pred_fun @ D @ A
        @ ^ [Uu: D] : $true
        @ ( comp @ B @ $o @ A @ Q @ F2 )
        @ X4 ) ) ).

% fun.pred_map
thf(fact_125_comp__cong,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,E: $tType,F2: B > A,G: C > B,X4: C,F3: D > A,G3: E > D,X7: E] :
      ( ( ( F2 @ ( G @ X4 ) )
        = ( F3 @ ( G3 @ X7 ) ) )
     => ( ( comp @ B @ A @ C @ F2 @ G @ X4 )
        = ( comp @ D @ A @ E @ F3 @ G3 @ X7 ) ) ) ).

% comp_cong
thf(fact_126_comp__apply__eq,axiom,
    ! [B: $tType,D: $tType,A: $tType,C: $tType,F2: B > A,G: C > B,X4: C,H: D > A,K: C > D] :
      ( ( ( F2 @ ( G @ X4 ) )
        = ( H @ ( K @ X4 ) ) )
     => ( ( comp @ B @ A @ C @ F2 @ G @ X4 )
        = ( comp @ D @ A @ C @ H @ K @ X4 ) ) ) ).

% comp_apply_eq
thf(fact_127_rewriteL__comp__comp,axiom,
    ! [C: $tType,B: $tType,A: $tType,D: $tType,F2: C > B,G: A > C,L: A > B,H: D > A] :
      ( ( ( comp @ C @ B @ A @ F2 @ G )
        = L )
     => ( ( comp @ C @ B @ D @ F2 @ ( comp @ A @ C @ D @ G @ H ) )
        = ( comp @ A @ B @ D @ L @ H ) ) ) ).

% rewriteL_comp_comp
thf(fact_128_rewriteR__comp__comp,axiom,
    ! [C: $tType,D: $tType,B: $tType,A: $tType,G: C > B,H: A > C,R2: A > B,F2: B > D] :
      ( ( ( comp @ C @ B @ A @ G @ H )
        = R2 )
     => ( ( comp @ C @ D @ A @ ( comp @ B @ D @ C @ F2 @ G ) @ H )
        = ( comp @ B @ D @ A @ F2 @ R2 ) ) ) ).

% rewriteR_comp_comp
thf(fact_129_fun_Opred__True,axiom,
    ! [A: $tType,D: $tType] :
      ( ( basic_pred_fun @ D @ A
        @ ^ [Uu: D] : $true
        @ ^ [Uu: A] : $true )
      = ( ^ [Uu: D > A] : $true ) ) ).

% fun.pred_True
thf(fact_130_pred__funI,axiom,
    ! [B: $tType,A: $tType,A4: A > $o,B2: B > $o,F2: A > B] :
      ( ! [X: A] :
          ( ( A4 @ X )
         => ( B2 @ ( F2 @ X ) ) )
     => ( basic_pred_fun @ A @ B @ A4 @ B2 @ F2 ) ) ).

% pred_funI
thf(fact_131_fun_Omap__cong__pred,axiom,
    ! [B: $tType,A: $tType,D: $tType,X4: D > A,Ya: D > A,F2: A > B,G: A > B] :
      ( ( X4 = Ya )
     => ( ( basic_pred_fun @ D @ A
          @ ^ [Uu: D] : $true
          @ ^ [Z3: A] :
              ( ( F2 @ Z3 )
              = ( G @ Z3 ) )
          @ Ya )
       => ( ( comp @ A @ B @ D @ F2 @ X4 )
          = ( comp @ A @ B @ D @ G @ Ya ) ) ) ) ).

% fun.map_cong_pred
thf(fact_132_rewriteR__comp__comp2,axiom,
    ! [C: $tType,B: $tType,E: $tType,D: $tType,A: $tType,G: C > B,H: A > C,R1: D > B,R22: A > D,F2: B > E,L: D > E] :
      ( ( ( comp @ C @ B @ A @ G @ H )
        = ( comp @ D @ B @ A @ R1 @ R22 ) )
     => ( ( ( comp @ B @ E @ D @ F2 @ R1 )
          = L )
       => ( ( comp @ C @ E @ A @ ( comp @ B @ E @ C @ F2 @ G ) @ H )
          = ( comp @ D @ E @ A @ L @ R22 ) ) ) ) ).

% rewriteR_comp_comp2
thf(fact_133_rewriteL__comp__comp2,axiom,
    ! [A: $tType,C: $tType,B: $tType,D: $tType,E: $tType,F2: C > B,G: A > C,L1: D > B,L2: A > D,H: E > A,R2: E > D] :
      ( ( ( comp @ C @ B @ A @ F2 @ G )
        = ( comp @ D @ B @ A @ L1 @ L2 ) )
     => ( ( ( comp @ A @ D @ E @ L2 @ H )
          = R2 )
       => ( ( comp @ C @ B @ E @ F2 @ ( comp @ A @ C @ E @ G @ H ) )
          = ( comp @ D @ B @ E @ L1 @ R2 ) ) ) ) ).

% rewriteL_comp_comp2
thf(fact_134_pick__middlep__def,axiom,
    ! [C: $tType,A: $tType,B: $tType] :
      ( ( bNF_pick_middlep @ B @ A @ C )
      = ( ^ [P: B > A > $o,Q3: A > C > $o,A3: B,C3: C] :
          @+[B4: A] :
            ( ( P @ A3 @ B4 )
            & ( Q3 @ B4 @ C3 ) ) ) ) ).

% pick_middlep_def
thf(fact_135_streams__def,axiom,
    ! [A: $tType] :
      ( ( streams @ A )
      = ( ^ [A7: set @ A] :
            ( collect @ ( stream @ A )
            @ ( streamsp @ A
              @ ^ [X5: A] : ( member2 @ A @ X5 @ A7 ) ) ) ) ) ).

% streams_def
thf(fact_136_streamsp__streams__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( streamsp @ A
        @ ^ [X5: A] : ( member2 @ A @ X5 @ A4 ) )
      = ( ^ [X5: stream @ A] : ( member2 @ ( stream @ A ) @ X5 @ ( streams @ A @ A4 ) ) ) ) ).

% streamsp_streams_eq
thf(fact_137_stream__all__Stream,axiom,
    ! [A: $tType,P2: A > $o,X4: A,X3: stream @ A] :
      ( ( stream_all @ A @ P2 @ ( sCons @ A @ X4 @ X3 ) )
      = ( ( P2 @ X4 )
        & ( stream_all @ A @ P2 @ X3 ) ) ) ).

% stream_all_Stream
thf(fact_138_streamsp_Ocases,axiom,
    ! [A: $tType,A4: A > $o,A2: stream @ A] :
      ( ( streamsp @ A @ A4 @ A2 )
     => ~ ! [A6: A,S6: stream @ A] :
            ( ( A2
              = ( sCons @ A @ A6 @ S6 ) )
           => ( ( A4 @ A6 )
             => ~ ( streamsp @ A @ A4 @ S6 ) ) ) ) ).

% streamsp.cases
thf(fact_139_streamsp_Osimps,axiom,
    ! [A: $tType] :
      ( ( streamsp @ A )
      = ( ^ [A7: A > $o,A3: stream @ A] :
          ? [B4: A,S: stream @ A] :
            ( ( A3
              = ( sCons @ A @ B4 @ S ) )
            & ( A7 @ B4 )
            & ( streamsp @ A @ A7 @ S ) ) ) ) ).

% streamsp.simps
thf(fact_140_streamsp_Ocoinduct,axiom,
    ! [A: $tType,X3: ( stream @ A ) > $o,X4: stream @ A,A4: A > $o] :
      ( ( X3 @ X4 )
     => ( ! [X: stream @ A] :
            ( ( X3 @ X )
           => ? [A5: A,S5: stream @ A] :
                ( ( X
                  = ( sCons @ A @ A5 @ S5 ) )
                & ( A4 @ A5 )
                & ( ( X3 @ S5 )
                  | ( streamsp @ A @ A4 @ S5 ) ) ) )
       => ( streamsp @ A @ A4 @ X4 ) ) ) ).

% streamsp.coinduct
thf(fact_141_treeFI_Ocoinduct__strong,axiom,
    ! [A: $tType,R: ( treeFI @ A ) > ( treeFI @ A ) > $o,TreeFI: treeFI @ A,TreeFI2: treeFI @ A] :
      ( ( R @ TreeFI @ TreeFI2 )
     => ( ! [TreeFI4: treeFI @ A,TreeFI5: treeFI @ A] :
            ( ( R @ TreeFI4 @ TreeFI5 )
           => ( ( ( lab @ A @ TreeFI4 )
                = ( lab @ A @ TreeFI5 ) )
              & ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ A )
                @ ^ [TreeFIa: treeFI @ A,TreeFIa2: treeFI @ A] :
                    ( ( R @ TreeFIa @ TreeFIa2 )
                    | ( TreeFIa = TreeFIa2 ) )
                @ ( sub @ A @ TreeFI4 )
                @ ( sub @ A @ TreeFI5 ) ) ) )
       => ( TreeFI = TreeFI2 ) ) ) ).

% treeFI.coinduct_strong
thf(fact_142_sset__induct,axiom,
    ! [A: $tType,Y: A,S2: stream @ A,P2: A > ( stream @ A ) > $o] :
      ( ( member2 @ A @ Y @ ( sset @ A @ S2 ) )
     => ( ! [S6: stream @ A] : ( P2 @ ( shd @ A @ S6 ) @ S6 )
       => ( ! [S6: stream @ A,Y5: A] :
              ( ( member2 @ A @ Y5 @ ( sset @ A @ ( stl @ A @ S6 ) ) )
             => ( ( P2 @ Y5 @ ( stl @ A @ S6 ) )
               => ( P2 @ Y5 @ S6 ) ) )
         => ( P2 @ Y @ S2 ) ) ) ) ).

% sset_induct
thf(fact_143_vimage2p__comp,axiom,
    ! [E: $tType,D: $tType,F4: $tType,A: $tType,C: $tType,B: $tType,G4: $tType,F1: F4 > A,F22: D > F4,G1: G4 > B,G23: E > G4] :
      ( ( bNF_vimage2p @ D @ A @ E @ B @ C @ ( comp @ F4 @ A @ D @ F1 @ F22 ) @ ( comp @ G4 @ B @ E @ G1 @ G23 ) )
      = ( comp @ ( F4 > G4 > C ) @ ( D > E > C ) @ ( A > B > C ) @ ( bNF_vimage2p @ D @ F4 @ E @ G4 @ C @ F22 @ G23 ) @ ( bNF_vimage2p @ F4 @ A @ G4 @ B @ C @ F1 @ G1 ) ) ) ).

% vimage2p_comp
thf(fact_144_sdrop__smap2,axiom,
    ! [B: $tType,A: $tType,C: $tType,N2: nat,F2: B > C > A,S12: stream @ B,S23: stream @ C] :
      ( ( sdrop @ A @ N2 @ ( smap2 @ B @ C @ A @ F2 @ S12 @ S23 ) )
      = ( smap2 @ B @ C @ A @ F2 @ ( sdrop @ B @ N2 @ S12 ) @ ( sdrop @ C @ N2 @ S23 ) ) ) ).

% sdrop_smap2
thf(fact_145_sdrop__smap,axiom,
    ! [A: $tType,B: $tType,N2: nat,F2: B > A,S2: stream @ B] :
      ( ( sdrop @ A @ N2 @ ( smap @ B @ A @ F2 @ S2 ) )
      = ( smap @ B @ A @ F2 @ ( sdrop @ B @ N2 @ S2 ) ) ) ).

% sdrop_smap
thf(fact_146_stream_Opred__mono__strong,axiom,
    ! [A: $tType,P2: A > $o,X4: stream @ A,Pa: A > $o] :
      ( ( pred_stream @ A @ P2 @ X4 )
     => ( ! [Z4: A] :
            ( ( member2 @ A @ Z4 @ ( sset @ A @ X4 ) )
           => ( ( P2 @ Z4 )
             => ( Pa @ Z4 ) ) )
       => ( pred_stream @ A @ Pa @ X4 ) ) ) ).

% stream.pred_mono_strong
thf(fact_147_stream_Opred__cong,axiom,
    ! [A: $tType,X4: stream @ A,Ya: stream @ A,P2: A > $o,Pa: A > $o] :
      ( ( X4 = Ya )
     => ( ! [Z4: A] :
            ( ( member2 @ A @ Z4 @ ( sset @ A @ Ya ) )
           => ( ( P2 @ Z4 )
              = ( Pa @ Z4 ) ) )
       => ( ( pred_stream @ A @ P2 @ X4 )
          = ( pred_stream @ A @ Pa @ Ya ) ) ) ) ).

% stream.pred_cong
thf(fact_148_vimage2p__cong,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,R: A > B > C,S4: A > B > C,F2: D > A,G: E > B] :
      ( ( R = S4 )
     => ( ( bNF_vimage2p @ D @ A @ E @ B @ C @ F2 @ G @ R )
        = ( bNF_vimage2p @ D @ A @ E @ B @ C @ F2 @ G @ S4 ) ) ) ).

% vimage2p_cong
thf(fact_149_stream_Oinj__map__strong,axiom,
    ! [B: $tType,A: $tType,X4: stream @ A,Xa: stream @ A,F2: A > B,Fa: A > B] :
      ( ! [Z4: A,Za: A] :
          ( ( member2 @ A @ Z4 @ ( sset @ A @ X4 ) )
         => ( ( member2 @ A @ Za @ ( sset @ A @ Xa ) )
           => ( ( ( F2 @ Z4 )
                = ( Fa @ Za ) )
             => ( Z4 = Za ) ) ) )
     => ( ( ( smap @ A @ B @ F2 @ X4 )
          = ( smap @ A @ B @ Fa @ Xa ) )
       => ( X4 = Xa ) ) ) ).

% stream.inj_map_strong
thf(fact_150_stream_Omap__cong0,axiom,
    ! [B: $tType,A: $tType,X4: stream @ A,F2: A > B,G: A > B] :
      ( ! [Z4: A] :
          ( ( member2 @ A @ Z4 @ ( sset @ A @ X4 ) )
         => ( ( F2 @ Z4 )
            = ( G @ Z4 ) ) )
     => ( ( smap @ A @ B @ F2 @ X4 )
        = ( smap @ A @ B @ G @ X4 ) ) ) ).

% stream.map_cong0
thf(fact_151_stream_Omap__cong,axiom,
    ! [B: $tType,A: $tType,X4: stream @ A,Ya: stream @ A,F2: A > B,G: A > B] :
      ( ( X4 = Ya )
     => ( ! [Z4: A] :
            ( ( member2 @ A @ Z4 @ ( sset @ A @ Ya ) )
           => ( ( F2 @ Z4 )
              = ( G @ Z4 ) ) )
       => ( ( smap @ A @ B @ F2 @ X4 )
          = ( smap @ A @ B @ G @ Ya ) ) ) ) ).

% stream.map_cong
thf(fact_152_stream_Oset__intros_I2_J,axiom,
    ! [A: $tType,X4: A,A22: stream @ A,A1: A] :
      ( ( member2 @ A @ X4 @ ( sset @ A @ A22 ) )
     => ( member2 @ A @ X4 @ ( sset @ A @ ( sCons @ A @ A1 @ A22 ) ) ) ) ).

% stream.set_intros(2)
thf(fact_153_stream_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A22: stream @ A] : ( member2 @ A @ A1 @ ( sset @ A @ ( sCons @ A @ A1 @ A22 ) ) ) ).

% stream.set_intros(1)
thf(fact_154_stream_Oset__cases,axiom,
    ! [A: $tType,E2: A,A2: stream @ A] :
      ( ( member2 @ A @ E2 @ ( sset @ A @ A2 ) )
     => ( ! [Z2: stream @ A] :
            ( A2
           != ( sCons @ A @ E2 @ Z2 ) )
       => ~ ! [Z1: A,Z2: stream @ A] :
              ( ( A2
                = ( sCons @ A @ Z1 @ Z2 ) )
             => ~ ( member2 @ A @ E2 @ ( sset @ A @ Z2 ) ) ) ) ) ).

% stream.set_cases
thf(fact_155_stream_Oset__induct,axiom,
    ! [A: $tType,X4: A,A2: stream @ A,P2: A > ( stream @ A ) > $o] :
      ( ( member2 @ A @ X4 @ ( sset @ A @ A2 ) )
     => ( ! [Z1: A,Z2: stream @ A] : ( P2 @ Z1 @ ( sCons @ A @ Z1 @ Z2 ) )
       => ( ! [Z1: A,Z2: stream @ A,Xa2: A] :
              ( ( member2 @ A @ Xa2 @ ( sset @ A @ Z2 ) )
             => ( ( P2 @ Xa2 @ Z2 )
               => ( P2 @ Xa2 @ ( sCons @ A @ Z1 @ Z2 ) ) ) )
         => ( P2 @ X4 @ A2 ) ) ) ) ).

% stream.set_induct
thf(fact_156_shd__sset,axiom,
    ! [A: $tType,A2: stream @ A] : ( member2 @ A @ ( shd @ A @ A2 ) @ ( sset @ A @ A2 ) ) ).

% shd_sset
thf(fact_157_stl__sset,axiom,
    ! [A: $tType,X4: A,A2: stream @ A] :
      ( ( member2 @ A @ X4 @ ( sset @ A @ ( stl @ A @ A2 ) ) )
     => ( member2 @ A @ X4 @ ( sset @ A @ A2 ) ) ) ).

% stl_sset
thf(fact_158_vimage2p__def,axiom,
    ! [B: $tType,E: $tType,C: $tType,D: $tType,A: $tType] :
      ( ( bNF_vimage2p @ A @ D @ B @ E @ C )
      = ( ^ [F: A > D,G2: B > E,R3: D > E > C,X5: A,Y4: B] : ( R3 @ ( F @ X5 ) @ ( G2 @ Y4 ) ) ) ) ).

% vimage2p_def
thf(fact_159_sdrop__stl,axiom,
    ! [A: $tType,N2: nat,S2: stream @ A] :
      ( ( sdrop @ A @ N2 @ ( stl @ A @ S2 ) )
      = ( stl @ A @ ( sdrop @ A @ N2 @ S2 ) ) ) ).

% sdrop_stl
thf(fact_160_Stream_Osmember__def,axiom,
    ! [A: $tType] :
      ( ( smember @ A )
      = ( ^ [X5: A,S: stream @ A] : ( member2 @ A @ X5 @ ( sset @ A @ S ) ) ) ) ).

% Stream.smember_def
thf(fact_161_treeFI_Ocoinduct,axiom,
    ! [A: $tType,R: ( treeFI @ A ) > ( treeFI @ A ) > $o,TreeFI: treeFI @ A,TreeFI2: treeFI @ A] :
      ( ( R @ TreeFI @ TreeFI2 )
     => ( ! [TreeFI4: treeFI @ A,TreeFI5: treeFI @ A] :
            ( ( R @ TreeFI4 @ TreeFI5 )
           => ( ( ( lab @ A @ TreeFI4 )
                = ( lab @ A @ TreeFI5 ) )
              & ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ A ) @ R @ ( sub @ A @ TreeFI4 ) @ ( sub @ A @ TreeFI5 ) ) ) )
       => ( TreeFI = TreeFI2 ) ) ) ).

% treeFI.coinduct
thf(fact_162_list__all2__same,axiom,
    ! [A: $tType,P2: A > A > $o,Xs: list @ A] :
      ( ( list_all2 @ A @ A @ P2 @ Xs @ Xs )
      = ( ! [X5: A] :
            ( ( member2 @ A @ X5 @ ( set2 @ A @ Xs ) )
           => ( P2 @ X5 @ X5 ) ) ) ) ).

% list_all2_same
thf(fact_163_list_Orel__cong,axiom,
    ! [A: $tType,B: $tType,X4: list @ A,Ya: list @ A,Y: list @ B,Xa: list @ B,R: A > B > $o,Ra: A > B > $o] :
      ( ( X4 = Ya )
     => ( ( Y = Xa )
       => ( ! [Z4: A,Yb: B] :
              ( ( member2 @ A @ Z4 @ ( set2 @ A @ Ya ) )
             => ( ( member2 @ B @ Yb @ ( set2 @ B @ Xa ) )
               => ( ( R @ Z4 @ Yb )
                  = ( Ra @ Z4 @ Yb ) ) ) )
         => ( ( list_all2 @ A @ B @ R @ X4 @ Y )
            = ( list_all2 @ A @ B @ Ra @ Ya @ Xa ) ) ) ) ) ).

% list.rel_cong
thf(fact_164_list_Orel__mono__strong,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X4: list @ A,Y: list @ B,Ra: A > B > $o] :
      ( ( list_all2 @ A @ B @ R @ X4 @ Y )
     => ( ! [Z4: A,Yb: B] :
            ( ( member2 @ A @ Z4 @ ( set2 @ A @ X4 ) )
           => ( ( member2 @ B @ Yb @ ( set2 @ B @ Y ) )
             => ( ( R @ Z4 @ Yb )
               => ( Ra @ Z4 @ Yb ) ) ) )
       => ( list_all2 @ A @ B @ Ra @ X4 @ Y ) ) ) ).

% list.rel_mono_strong
thf(fact_165_list_Orel__refl__strong,axiom,
    ! [A: $tType,X4: list @ A,Ra: A > A > $o] :
      ( ! [Z4: A] :
          ( ( member2 @ A @ Z4 @ ( set2 @ A @ X4 ) )
         => ( Ra @ Z4 @ Z4 ) )
     => ( list_all2 @ A @ A @ Ra @ X4 @ X4 ) ) ).

% list.rel_refl_strong
thf(fact_166_treeFI_Orel__coinduct,axiom,
    ! [A: $tType,B: $tType,P2: ( treeFI @ A ) > ( treeFI @ B ) > $o,X4: treeFI @ A,Y: treeFI @ B,R: A > B > $o] :
      ( ( P2 @ X4 @ Y )
     => ( ! [TreeFI4: treeFI @ A,TreeFI5: treeFI @ B] :
            ( ( P2 @ TreeFI4 @ TreeFI5 )
           => ( ( R @ ( lab @ A @ TreeFI4 ) @ ( lab @ B @ TreeFI5 ) )
              & ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ P2 @ ( sub @ A @ TreeFI4 ) @ ( sub @ B @ TreeFI5 ) ) ) )
       => ( rel_treeFI @ A @ B @ R @ X4 @ Y ) ) ) ).

% treeFI.rel_coinduct
thf(fact_167_treeFI_Orel__sel,axiom,
    ! [B: $tType,A: $tType] :
      ( ( rel_treeFI @ A @ B )
      = ( ^ [R3: A > B > $o,A3: treeFI @ A,B4: treeFI @ B] :
            ( ( R3 @ ( lab @ A @ A3 ) @ ( lab @ B @ B4 ) )
            & ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R3 ) @ ( sub @ A @ A3 ) @ ( sub @ B @ B4 ) ) ) ) ) ).

% treeFI.rel_sel
thf(fact_168_in__set__member,axiom,
    ! [A: $tType,X4: A,Xs: list @ A] :
      ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
      = ( member @ A @ Xs @ X4 ) ) ).

% in_set_member
thf(fact_169_treeFI_Orel__inject,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X1: A,X22: list @ ( treeFI @ A ),Y1: B,Y2: list @ ( treeFI @ B )] :
      ( ( rel_treeFI @ A @ B @ R @ ( tree @ A @ X1 @ X22 ) @ ( tree @ B @ Y1 @ Y2 ) )
      = ( ( R @ X1 @ Y1 )
        & ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) @ X22 @ Y2 ) ) ) ).

% treeFI.rel_inject
thf(fact_170_treeFI_Orel__eq,axiom,
    ! [A: $tType] :
      ( ( rel_treeFI @ A @ A
        @ ^ [Y3: A,Z: A] : ( Y3 = Z ) )
      = ( ^ [Y3: treeFI @ A,Z: treeFI @ A] : ( Y3 = Z ) ) ) ).

% treeFI.rel_eq
thf(fact_171_treeFI_Orel__refl,axiom,
    ! [B: $tType,Ra: B > B > $o,X4: treeFI @ B] :
      ( ! [X: B] : ( Ra @ X @ X )
     => ( rel_treeFI @ B @ B @ Ra @ X4 @ X4 ) ) ).

% treeFI.rel_refl
thf(fact_172_treeFI_Orel__cong,axiom,
    ! [A: $tType,B: $tType,X4: treeFI @ A,Ya: treeFI @ A,Y: treeFI @ B,Xa: treeFI @ B,R: A > B > $o,Ra: A > B > $o] :
      ( ( X4 = Ya )
     => ( ( Y = Xa )
       => ( ! [Z4: A,Yb: B] :
              ( ( member2 @ A @ Z4 @ ( set_treeFI @ A @ Ya ) )
             => ( ( member2 @ B @ Yb @ ( set_treeFI @ B @ Xa ) )
               => ( ( R @ Z4 @ Yb )
                  = ( Ra @ Z4 @ Yb ) ) ) )
         => ( ( rel_treeFI @ A @ B @ R @ X4 @ Y )
            = ( rel_treeFI @ A @ B @ Ra @ Ya @ Xa ) ) ) ) ) ).

% treeFI.rel_cong
thf(fact_173_treeFI_Orel__mono__strong,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X4: treeFI @ A,Y: treeFI @ B,Ra: A > B > $o] :
      ( ( rel_treeFI @ A @ B @ R @ X4 @ Y )
     => ( ! [Z4: A,Yb: B] :
            ( ( member2 @ A @ Z4 @ ( set_treeFI @ A @ X4 ) )
           => ( ( member2 @ B @ Yb @ ( set_treeFI @ B @ Y ) )
             => ( ( R @ Z4 @ Yb )
               => ( Ra @ Z4 @ Yb ) ) ) )
       => ( rel_treeFI @ A @ B @ Ra @ X4 @ Y ) ) ) ).

% treeFI.rel_mono_strong
thf(fact_174_treeFI_Orel__refl__strong,axiom,
    ! [A: $tType,X4: treeFI @ A,Ra: A > A > $o] :
      ( ! [Z4: A] :
          ( ( member2 @ A @ Z4 @ ( set_treeFI @ A @ X4 ) )
         => ( Ra @ Z4 @ Z4 ) )
     => ( rel_treeFI @ A @ A @ Ra @ X4 @ X4 ) ) ).

% treeFI.rel_refl_strong
thf(fact_175_treeFI_Orel__cases,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,A2: treeFI @ A,B3: treeFI @ B] :
      ( ( rel_treeFI @ A @ B @ R @ A2 @ B3 )
     => ~ ! [X1a: A,X2a: list @ ( treeFI @ A )] :
            ( ( A2
              = ( tree @ A @ X1a @ X2a ) )
           => ! [Y1a: B,Y2a: list @ ( treeFI @ B )] :
                ( ( B3
                  = ( tree @ B @ Y1a @ Y2a ) )
               => ( ( R @ X1a @ Y1a )
                 => ~ ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) @ X2a @ Y2a ) ) ) ) ) ).

% treeFI.rel_cases
thf(fact_176_treeFI_Orel__intros,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X1: A,Y1: B,X22: list @ ( treeFI @ A ),Y2: list @ ( treeFI @ B )] :
      ( ( R @ X1 @ Y1 )
     => ( ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) @ X22 @ Y2 )
       => ( rel_treeFI @ A @ B @ R @ ( tree @ A @ X1 @ X22 ) @ ( tree @ B @ Y1 @ Y2 ) ) ) ) ).

% treeFI.rel_intros
thf(fact_177_treeFI_Osel__transfer_I2_J,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] : ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( list @ ( treeFI @ A ) ) @ ( list @ ( treeFI @ B ) ) @ ( rel_treeFI @ A @ B @ R ) @ ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) ) @ ( sub @ A ) @ ( sub @ B ) ) ).

% treeFI.sel_transfer(2)
thf(fact_178_sdrop__simps_I1_J,axiom,
    ! [A: $tType,N2: nat,S2: stream @ A] :
      ( ( shd @ A @ ( sdrop @ A @ N2 @ S2 ) )
      = ( snth @ A @ S2 @ N2 ) ) ).

% sdrop_simps(1)
thf(fact_179_stream__all__iff,axiom,
    ! [A: $tType] :
      ( ( stream_all @ A )
      = ( ^ [P: A > $o,S: stream @ A] :
          ! [X5: A] :
            ( ( member2 @ A @ X5 @ ( sset @ A @ S ) )
           => ( P @ X5 ) ) ) ) ).

% stream_all_iff
thf(fact_180_snth__smap,axiom,
    ! [A: $tType,B: $tType,F2: B > A,S2: stream @ B,N2: nat] :
      ( ( snth @ A @ ( smap @ B @ A @ F2 @ S2 ) @ N2 )
      = ( F2 @ ( snth @ B @ S2 @ N2 ) ) ) ).

% snth_smap
thf(fact_181_snth__smap2,axiom,
    ! [B: $tType,A: $tType,C: $tType,F2: B > C > A,S12: stream @ B,S23: stream @ C,N2: nat] :
      ( ( snth @ A @ ( smap2 @ B @ C @ A @ F2 @ S12 @ S23 ) @ N2 )
      = ( F2 @ ( snth @ B @ S12 @ N2 ) @ ( snth @ C @ S23 @ N2 ) ) ) ).

% snth_smap2
thf(fact_182_fun_Omap__transfer,axiom,
    ! [A: $tType,B: $tType,D: $tType,G4: $tType,F4: $tType,Rb: A > F4 > $o,Sd: B > G4 > $o] :
      ( bNF_rel_fun @ ( A > B ) @ ( F4 > G4 ) @ ( ( D > A ) > D > B ) @ ( ( D > F4 ) > D > G4 ) @ ( bNF_rel_fun @ A @ F4 @ B @ G4 @ Rb @ Sd )
      @ ( bNF_rel_fun @ ( D > A ) @ ( D > F4 ) @ ( D > B ) @ ( D > G4 )
        @ ( bNF_rel_fun @ D @ D @ A @ F4
          @ ^ [Y3: D,Z: D] : ( Y3 = Z )
          @ Rb )
        @ ( bNF_rel_fun @ D @ D @ B @ G4
          @ ^ [Y3: D,Z: D] : ( Y3 = Z )
          @ Sd ) )
      @ ( comp @ A @ B @ D )
      @ ( comp @ F4 @ G4 @ D ) ) ).

% fun.map_transfer
thf(fact_183_snth__sset,axiom,
    ! [A: $tType,S2: stream @ A,N2: nat] : ( member2 @ A @ ( snth @ A @ S2 @ N2 ) @ ( sset @ A @ S2 ) ) ).

% snth_sset
thf(fact_184_fun_Orel__map_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,D: $tType,Sa: A > C > $o,X4: D > A,G: B > C,Y: D > B] :
      ( ( bNF_rel_fun @ D @ D @ A @ C
        @ ^ [Y3: D,Z: D] : ( Y3 = Z )
        @ Sa
        @ X4
        @ ( comp @ B @ C @ D @ G @ Y ) )
      = ( bNF_rel_fun @ D @ D @ A @ B
        @ ^ [Y3: D,Z: D] : ( Y3 = Z )
        @ ^ [X5: A,Y4: B] : ( Sa @ X5 @ ( G @ Y4 ) )
        @ X4
        @ Y ) ) ).

% fun.rel_map(2)
thf(fact_185_fun_Orel__map_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,D: $tType,Sb: C > B > $o,I: A > C,X4: D > A,Y: D > B] :
      ( ( bNF_rel_fun @ D @ D @ C @ B
        @ ^ [Y3: D,Z: D] : ( Y3 = Z )
        @ Sb
        @ ( comp @ A @ C @ D @ I @ X4 )
        @ Y )
      = ( bNF_rel_fun @ D @ D @ A @ B
        @ ^ [Y3: D,Z: D] : ( Y3 = Z )
        @ ^ [X5: A] : ( Sb @ ( I @ X5 ) )
        @ X4
        @ Y ) ) ).

% fun.rel_map(1)
thf(fact_186_comp__transfer,axiom,
    ! [A: $tType,B: $tType,E: $tType,F4: $tType,D: $tType,C: $tType,B2: A > C > $o,C4: B > D > $o,A4: E > F4 > $o] : ( bNF_rel_fun @ ( A > B ) @ ( C > D ) @ ( ( E > A ) > E > B ) @ ( ( F4 > C ) > F4 > D ) @ ( bNF_rel_fun @ A @ C @ B @ D @ B2 @ C4 ) @ ( bNF_rel_fun @ ( E > A ) @ ( F4 > C ) @ ( E > B ) @ ( F4 > D ) @ ( bNF_rel_fun @ E @ F4 @ A @ C @ A4 @ B2 ) @ ( bNF_rel_fun @ E @ F4 @ B @ D @ A4 @ C4 ) ) @ ( comp @ A @ B @ E ) @ ( comp @ C @ D @ F4 ) ) ).

% comp_transfer
thf(fact_187_Ball__comp__iff,axiom,
    ! [C: $tType,B: $tType,A: $tType,A4: B > ( set @ C ),F2: C > $o,G: A > B] :
      ( ( comp @ B @ $o @ A
        @ ^ [X5: B] :
          ! [Y4: C] :
            ( ( member2 @ C @ Y4 @ ( A4 @ X5 ) )
           => ( F2 @ Y4 ) )
        @ G )
      = ( ^ [X5: A] :
          ! [Y4: C] :
            ( ( member2 @ C @ Y4 @ ( comp @ B @ ( set @ C ) @ A @ A4 @ G @ X5 ) )
           => ( F2 @ Y4 ) ) ) ) ).

% Ball_comp_iff
thf(fact_188_smap2__alt,axiom,
    ! [A: $tType,B: $tType,C: $tType,F2: B > C > A,S12: stream @ B,S23: stream @ C,S2: stream @ A] :
      ( ( ( smap2 @ B @ C @ A @ F2 @ S12 @ S23 )
        = S2 )
      = ( ! [N3: nat] :
            ( ( F2 @ ( snth @ B @ S12 @ N3 ) @ ( snth @ C @ S23 @ N3 ) )
            = ( snth @ A @ S2 @ N3 ) ) ) ) ).

% smap2_alt
thf(fact_189_fun_Opred__transfer,axiom,
    ! [A: $tType,B: $tType,D: $tType,R: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( D > A ) > $o ) @ ( ( D > B ) > $o )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ R
        @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) )
      @ ( bNF_rel_fun @ ( D > A ) @ ( D > B ) @ $o @ $o
        @ ( bNF_rel_fun @ D @ D @ A @ B
          @ ^ [Y3: D,Z: D] : ( Y3 = Z )
          @ R )
        @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) )
      @ ( basic_pred_fun @ D @ A
        @ ^ [Uu: D] : $true )
      @ ( basic_pred_fun @ D @ B
        @ ^ [Uu: D] : $true ) ) ).

% fun.pred_transfer
thf(fact_190_smap__alt,axiom,
    ! [A: $tType,B: $tType,F2: B > A,S2: stream @ B,S3: stream @ A] :
      ( ( ( smap @ B @ A @ F2 @ S2 )
        = S3 )
      = ( ! [N3: nat] :
            ( ( F2 @ ( snth @ B @ S2 @ N3 ) )
            = ( snth @ A @ S3 @ N3 ) ) ) ) ).

% smap_alt
thf(fact_191_fun_Orel__transfer,axiom,
    ! [B: $tType,A: $tType,C: $tType,E: $tType,D: $tType,Sa: A > C > $o,Sc: B > E > $o] :
      ( bNF_rel_fun @ ( A > B > $o ) @ ( C > E > $o ) @ ( ( D > A ) > ( D > B ) > $o ) @ ( ( D > C ) > ( D > E ) > $o )
      @ ( bNF_rel_fun @ A @ C @ ( B > $o ) @ ( E > $o ) @ Sa
        @ ( bNF_rel_fun @ B @ E @ $o @ $o @ Sc
          @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) ) )
      @ ( bNF_rel_fun @ ( D > A ) @ ( D > C ) @ ( ( D > B ) > $o ) @ ( ( D > E ) > $o )
        @ ( bNF_rel_fun @ D @ D @ A @ C
          @ ^ [Y3: D,Z: D] : ( Y3 = Z )
          @ Sa )
        @ ( bNF_rel_fun @ ( D > B ) @ ( D > E ) @ $o @ $o
          @ ( bNF_rel_fun @ D @ D @ B @ E
            @ ^ [Y3: D,Z: D] : ( Y3 = Z )
            @ Sc )
          @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) ) )
      @ ( bNF_rel_fun @ D @ D @ A @ B
        @ ^ [Y3: D,Z: D] : ( Y3 = Z ) )
      @ ( bNF_rel_fun @ D @ D @ C @ E
        @ ^ [Y3: D,Z: D] : ( Y3 = Z ) ) ) ).

% fun.rel_transfer
thf(fact_192_fun_Orel__refl,axiom,
    ! [B: $tType,D: $tType,Ra: B > B > $o,X4: D > B] :
      ( ! [X: B] : ( Ra @ X @ X )
     => ( bNF_rel_fun @ D @ D @ B @ B
        @ ^ [Y3: D,Z: D] : ( Y3 = Z )
        @ Ra
        @ X4
        @ X4 ) ) ).

% fun.rel_refl
thf(fact_193_fun_Orel__eq,axiom,
    ! [A: $tType,D: $tType] :
      ( ( bNF_rel_fun @ D @ D @ A @ A
        @ ^ [Y3: D,Z: D] : ( Y3 = Z )
        @ ^ [Y3: A,Z: A] : ( Y3 = Z ) )
      = ( ^ [Y3: D > A,Z: D > A] : ( Y3 = Z ) ) ) ).

% fun.rel_eq
thf(fact_194_snth__in,axiom,
    ! [A: $tType,S2: stream @ A,X3: set @ A,N2: nat] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ X3 ) )
     => ( member2 @ A @ ( snth @ A @ S2 @ N2 ) @ X3 ) ) ).

% snth_in
thf(fact_195_streams__iff__snth,axiom,
    ! [A: $tType,S2: stream @ A,X3: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S2 @ ( streams @ A @ X3 ) )
      = ( ! [N3: nat] : ( member2 @ A @ ( snth @ A @ S2 @ N3 ) @ X3 ) ) ) ).

% streams_iff_snth
thf(fact_196_stream__all__def,axiom,
    ! [A: $tType] :
      ( ( stream_all @ A )
      = ( ^ [P: A > $o,S: stream @ A] :
          ! [P5: nat] : ( P @ ( snth @ A @ S @ P5 ) ) ) ) ).

% stream_all_def
thf(fact_197_treeFI_Osel__transfer_I1_J,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] : ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ B ) @ A @ B @ ( rel_treeFI @ A @ B @ R ) @ R @ ( lab @ A ) @ ( lab @ B ) ) ).

% treeFI.sel_transfer(1)
thf(fact_198_stream_Opred__set,axiom,
    ! [A: $tType] :
      ( ( pred_stream @ A )
      = ( ^ [P: A > $o,X5: stream @ A] :
          ! [Y4: A] :
            ( ( member2 @ A @ Y4 @ ( sset @ A @ X5 ) )
           => ( P @ Y4 ) ) ) ) ).

% stream.pred_set
thf(fact_199_snth__sset__smerge,axiom,
    ! [A: $tType,Ss: stream @ ( stream @ A ),N2: nat,M2: nat] : ( member2 @ A @ ( snth @ A @ ( snth @ ( stream @ A ) @ Ss @ N2 ) @ M2 ) @ ( sset @ A @ ( smerge @ A @ Ss ) ) ) ).

% snth_sset_smerge
thf(fact_200_sdrop__while__sdrop__LEAST,axiom,
    ! [A: $tType,P2: A > $o,S2: stream @ A] :
      ( ? [N4: nat] : ( P2 @ ( snth @ A @ S2 @ N4 ) )
     => ( ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P2 ) @ S2 )
        = ( sdrop @ A
          @ ( ord_Least @ nat
            @ ^ [N3: nat] : ( P2 @ ( snth @ A @ S2 @ N3 ) ) )
          @ S2 ) ) ) ).

% sdrop_while_sdrop_LEAST
thf(fact_201_o__rsp_I1_J,axiom,
    ! [A: $tType,B: $tType,E: $tType,F4: $tType,D: $tType,C: $tType,R23: A > C > $o,R32: B > D > $o,R12: E > F4 > $o] : ( bNF_rel_fun @ ( A > B ) @ ( C > D ) @ ( ( E > A ) > E > B ) @ ( ( F4 > C ) > F4 > D ) @ ( bNF_rel_fun @ A @ C @ B @ D @ R23 @ R32 ) @ ( bNF_rel_fun @ ( E > A ) @ ( F4 > C ) @ ( E > B ) @ ( F4 > D ) @ ( bNF_rel_fun @ E @ F4 @ A @ C @ R12 @ R23 ) @ ( bNF_rel_fun @ E @ F4 @ B @ D @ R12 @ R32 ) ) @ ( comp @ A @ B @ E ) @ ( comp @ C @ D @ F4 ) ) ).

% o_rsp(1)
thf(fact_202_treeFI_Ocase__transfer,axiom,
    ! [A: $tType,C: $tType,D: $tType,B: $tType,R: A > B > $o,S4: C > D > $o] : ( bNF_rel_fun @ ( A > ( list @ ( treeFI @ A ) ) > C ) @ ( B > ( list @ ( treeFI @ B ) ) > D ) @ ( ( treeFI @ A ) > C ) @ ( ( treeFI @ B ) > D ) @ ( bNF_rel_fun @ A @ B @ ( ( list @ ( treeFI @ A ) ) > C ) @ ( ( list @ ( treeFI @ B ) ) > D ) @ R @ ( bNF_rel_fun @ ( list @ ( treeFI @ A ) ) @ ( list @ ( treeFI @ B ) ) @ C @ D @ ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) ) @ S4 ) ) @ ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ B ) @ C @ D @ ( rel_treeFI @ A @ B @ R ) @ S4 ) @ ( case_treeFI @ A @ C ) @ ( case_treeFI @ B @ D ) ) ).

% treeFI.case_transfer
thf(fact_203_treeFI_Octr__transfer,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] : ( bNF_rel_fun @ A @ B @ ( ( list @ ( treeFI @ A ) ) > ( treeFI @ A ) ) @ ( ( list @ ( treeFI @ B ) ) > ( treeFI @ B ) ) @ R @ ( bNF_rel_fun @ ( list @ ( treeFI @ A ) ) @ ( list @ ( treeFI @ B ) ) @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) ) @ ( rel_treeFI @ A @ B @ R ) ) @ ( tree @ A ) @ ( tree @ B ) ) ).

% treeFI.ctr_transfer
thf(fact_204_treeFI_Odisc__transfer,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] :
      ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ B ) @ $o @ $o @ ( rel_treeFI @ A @ B @ R )
      @ ^ [Y3: $o,Z: $o] : ( Y3 = Z )
      @ ^ [TreeFI3: treeFI @ A] : ( TreeFI3 = TreeFI3 )
      @ ^ [TreeFI3: treeFI @ B] : ( TreeFI3 = TreeFI3 ) ) ).

% treeFI.disc_transfer
thf(fact_205_treeFI_Orel__transfer,axiom,
    ! [A: $tType,B: $tType,D: $tType,C: $tType,Sa: A > C > $o,Sc: B > D > $o] :
      ( bNF_rel_fun @ ( A > B > $o ) @ ( C > D > $o ) @ ( ( treeFI @ A ) > ( treeFI @ B ) > $o ) @ ( ( treeFI @ C ) > ( treeFI @ D ) > $o )
      @ ( bNF_rel_fun @ A @ C @ ( B > $o ) @ ( D > $o ) @ Sa
        @ ( bNF_rel_fun @ B @ D @ $o @ $o @ Sc
          @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) ) )
      @ ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ C ) @ ( ( treeFI @ B ) > $o ) @ ( ( treeFI @ D ) > $o ) @ ( rel_treeFI @ A @ C @ Sa )
        @ ( bNF_rel_fun @ ( treeFI @ B ) @ ( treeFI @ D ) @ $o @ $o @ ( rel_treeFI @ B @ D @ Sc )
          @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) ) )
      @ ( rel_treeFI @ A @ B )
      @ ( rel_treeFI @ C @ D ) ) ).

% treeFI.rel_transfer
thf(fact_206_o__rsp_I2_J,axiom,
    ! [E: $tType,F4: $tType,H2: $tType,G4: $tType,R12: E > F4 > $o] :
      ( bNF_rel_fun @ ( G4 > H2 ) @ ( G4 > H2 ) @ ( ( E > G4 ) > E > H2 ) @ ( ( F4 > G4 ) > F4 > H2 )
      @ ^ [Y3: G4 > H2,Z: G4 > H2] : ( Y3 = Z )
      @ ( bNF_rel_fun @ ( E > G4 ) @ ( F4 > G4 ) @ ( E > H2 ) @ ( F4 > H2 )
        @ ( bNF_rel_fun @ E @ F4 @ G4 @ G4 @ R12
          @ ^ [Y3: G4,Z: G4] : ( Y3 = Z ) )
        @ ( bNF_rel_fun @ E @ F4 @ H2 @ H2 @ R12
          @ ^ [Y3: H2,Z: H2] : ( Y3 = Z ) ) )
      @ ( comp @ G4 @ H2 @ E )
      @ ( comp @ G4 @ H2 @ F4 ) ) ).

% o_rsp(2)
thf(fact_207_abort__Bleast__def,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ( ( abort_Bleast @ A )
        = ( ^ [S7: set @ A,P: A > $o] :
              ( ord_Least @ A
              @ ^ [X5: A] :
                  ( ( member2 @ A @ X5 @ S7 )
                  & ( P @ X5 ) ) ) ) ) ) ).

% abort_Bleast_def
thf(fact_208_Bleast__def,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ( ( bleast @ A )
        = ( ^ [S7: set @ A,P: A > $o] :
              ( ord_Least @ A
              @ ^ [X5: A] :
                  ( ( member2 @ A @ X5 @ S7 )
                  & ( P @ X5 ) ) ) ) ) ) ).

% Bleast_def
thf(fact_209_treeFI_Opred__transfer,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( treeFI @ A ) > $o ) @ ( ( treeFI @ B ) > $o )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ R
        @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) )
      @ ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ B ) @ $o @ $o @ ( rel_treeFI @ A @ B @ R )
        @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) )
      @ ( pred_treeFI @ A )
      @ ( pred_treeFI @ B ) ) ).

% treeFI.pred_transfer
thf(fact_210_LeastI,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P2: A > $o,K: A] :
          ( ( P2 @ K )
         => ( P2 @ ( ord_Least @ A @ P2 ) ) ) ) ).

% LeastI
thf(fact_211_treeFI_Opred__cong,axiom,
    ! [A: $tType,X4: treeFI @ A,Ya: treeFI @ A,P2: A > $o,Pa: A > $o] :
      ( ( X4 = Ya )
     => ( ! [Z4: A] :
            ( ( member2 @ A @ Z4 @ ( set_treeFI @ A @ Ya ) )
           => ( ( P2 @ Z4 )
              = ( Pa @ Z4 ) ) )
       => ( ( pred_treeFI @ A @ P2 @ X4 )
          = ( pred_treeFI @ A @ Pa @ Ya ) ) ) ) ).

% treeFI.pred_cong
thf(fact_212_treeFI_Opred__mono__strong,axiom,
    ! [A: $tType,P2: A > $o,X4: treeFI @ A,Pa: A > $o] :
      ( ( pred_treeFI @ A @ P2 @ X4 )
     => ( ! [Z4: A] :
            ( ( member2 @ A @ Z4 @ ( set_treeFI @ A @ X4 ) )
           => ( ( P2 @ Z4 )
             => ( Pa @ Z4 ) ) )
       => ( pred_treeFI @ A @ Pa @ X4 ) ) ) ).

% treeFI.pred_mono_strong
thf(fact_213_treeFI_Opred__True,axiom,
    ! [A: $tType] :
      ( ( pred_treeFI @ A
        @ ^ [Uu: A] : $true )
      = ( ^ [Uu: treeFI @ A] : $true ) ) ).

% treeFI.pred_True
thf(fact_214_treeFI_Opred__set,axiom,
    ! [A: $tType] :
      ( ( pred_treeFI @ A )
      = ( ^ [P: A > $o,X5: treeFI @ A] :
          ! [Y4: A] :
            ( ( member2 @ A @ Y4 @ ( set_treeFI @ A @ X5 ) )
           => ( P @ Y4 ) ) ) ) ).

% treeFI.pred_set
thf(fact_215_treeFI_Opred__inject,axiom,
    ! [A: $tType,P2: A > $o,A2: A,Aa2: list @ ( treeFI @ A )] :
      ( ( pred_treeFI @ A @ P2 @ ( tree @ A @ A2 @ Aa2 ) )
      = ( ( P2 @ A2 )
        & ( list_all @ ( treeFI @ A ) @ ( pred_treeFI @ A @ P2 ) @ Aa2 ) ) ) ).

% treeFI.pred_inject
thf(fact_216_stream_Ocorec__transfer,axiom,
    ! [C: $tType,A: $tType,B: $tType,D: $tType,S4: C > D > $o,R: A > B > $o] :
      ( bNF_rel_fun @ ( C > A ) @ ( D > B ) @ ( ( C > $o ) > ( C > ( stream @ A ) ) > ( C > C ) > C > ( stream @ A ) ) @ ( ( D > $o ) > ( D > ( stream @ B ) ) > ( D > D ) > D > ( stream @ B ) ) @ ( bNF_rel_fun @ C @ D @ A @ B @ S4 @ R )
      @ ( bNF_rel_fun @ ( C > $o ) @ ( D > $o ) @ ( ( C > ( stream @ A ) ) > ( C > C ) > C > ( stream @ A ) ) @ ( ( D > ( stream @ B ) ) > ( D > D ) > D > ( stream @ B ) )
        @ ( bNF_rel_fun @ C @ D @ $o @ $o @ S4
          @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) )
        @ ( bNF_rel_fun @ ( C > ( stream @ A ) ) @ ( D > ( stream @ B ) ) @ ( ( C > C ) > C > ( stream @ A ) ) @ ( ( D > D ) > D > ( stream @ B ) ) @ ( bNF_rel_fun @ C @ D @ ( stream @ A ) @ ( stream @ B ) @ S4 @ ( stream_all2 @ A @ B @ R ) ) @ ( bNF_rel_fun @ ( C > C ) @ ( D > D ) @ ( C > ( stream @ A ) ) @ ( D > ( stream @ B ) ) @ ( bNF_rel_fun @ C @ D @ C @ D @ S4 @ S4 ) @ ( bNF_rel_fun @ C @ D @ ( stream @ A ) @ ( stream @ B ) @ S4 @ ( stream_all2 @ A @ B @ R ) ) ) ) )
      @ ( corec_stream @ C @ A )
      @ ( corec_stream @ D @ B ) ) ).

% stream.corec_transfer
thf(fact_217_stream_Orel__inject,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X1: A,X22: stream @ A,Y1: B,Y2: stream @ B] :
      ( ( stream_all2 @ A @ B @ R @ ( sCons @ A @ X1 @ X22 ) @ ( sCons @ B @ Y1 @ Y2 ) )
      = ( ( R @ X1 @ Y1 )
        & ( stream_all2 @ A @ B @ R @ X22 @ Y2 ) ) ) ).

% stream.rel_inject
thf(fact_218_stream_Osel__transfer_I2_J,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] : ( bNF_rel_fun @ ( stream @ A ) @ ( stream @ B ) @ ( stream @ A ) @ ( stream @ B ) @ ( stream_all2 @ A @ B @ R ) @ ( stream_all2 @ A @ B @ R ) @ ( stl @ A ) @ ( stl @ B ) ) ).

% stream.sel_transfer(2)
thf(fact_219_stream_Osel__transfer_I1_J,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] : ( bNF_rel_fun @ ( stream @ A ) @ ( stream @ B ) @ A @ B @ ( stream_all2 @ A @ B @ R ) @ R @ ( shd @ A ) @ ( shd @ B ) ) ).

% stream.sel_transfer(1)
thf(fact_220_stream_Orel__transfer,axiom,
    ! [A: $tType,B: $tType,D: $tType,C: $tType,Sa: A > C > $o,Sc: B > D > $o] :
      ( bNF_rel_fun @ ( A > B > $o ) @ ( C > D > $o ) @ ( ( stream @ A ) > ( stream @ B ) > $o ) @ ( ( stream @ C ) > ( stream @ D ) > $o )
      @ ( bNF_rel_fun @ A @ C @ ( B > $o ) @ ( D > $o ) @ Sa
        @ ( bNF_rel_fun @ B @ D @ $o @ $o @ Sc
          @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) ) )
      @ ( bNF_rel_fun @ ( stream @ A ) @ ( stream @ C ) @ ( ( stream @ B ) > $o ) @ ( ( stream @ D ) > $o ) @ ( stream_all2 @ A @ C @ Sa )
        @ ( bNF_rel_fun @ ( stream @ B ) @ ( stream @ D ) @ $o @ $o @ ( stream_all2 @ B @ D @ Sc )
          @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) ) )
      @ ( stream_all2 @ A @ B )
      @ ( stream_all2 @ C @ D ) ) ).

% stream.rel_transfer
thf(fact_221_stream_Odisc__transfer,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] :
      ( bNF_rel_fun @ ( stream @ A ) @ ( stream @ B ) @ $o @ $o @ ( stream_all2 @ A @ B @ R )
      @ ^ [Y3: $o,Z: $o] : ( Y3 = Z )
      @ ^ [Stream5: stream @ A] : ( Stream5 = Stream5 )
      @ ^ [Stream5: stream @ B] : ( Stream5 = Stream5 ) ) ).

% stream.disc_transfer
thf(fact_222_stream_Octr__transfer,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] : ( bNF_rel_fun @ A @ B @ ( ( stream @ A ) > ( stream @ A ) ) @ ( ( stream @ B ) > ( stream @ B ) ) @ R @ ( bNF_rel_fun @ ( stream @ A ) @ ( stream @ B ) @ ( stream @ A ) @ ( stream @ B ) @ ( stream_all2 @ A @ B @ R ) @ ( stream_all2 @ A @ B @ R ) ) @ ( sCons @ A ) @ ( sCons @ B ) ) ).

% stream.ctr_transfer
thf(fact_223_stream_Ocase__transfer,axiom,
    ! [A: $tType,C: $tType,D: $tType,B: $tType,R: A > B > $o,S4: C > D > $o] : ( bNF_rel_fun @ ( A > ( stream @ A ) > C ) @ ( B > ( stream @ B ) > D ) @ ( ( stream @ A ) > C ) @ ( ( stream @ B ) > D ) @ ( bNF_rel_fun @ A @ B @ ( ( stream @ A ) > C ) @ ( ( stream @ B ) > D ) @ R @ ( bNF_rel_fun @ ( stream @ A ) @ ( stream @ B ) @ C @ D @ ( stream_all2 @ A @ B @ R ) @ S4 ) ) @ ( bNF_rel_fun @ ( stream @ A ) @ ( stream @ B ) @ C @ D @ ( stream_all2 @ A @ B @ R ) @ S4 ) @ ( case_stream @ A @ C ) @ ( case_stream @ B @ D ) ) ).

% stream.case_transfer
thf(fact_224_stream_Opred__transfer,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( stream @ A ) > $o ) @ ( ( stream @ B ) > $o )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ R
        @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) )
      @ ( bNF_rel_fun @ ( stream @ A ) @ ( stream @ B ) @ $o @ $o @ ( stream_all2 @ A @ B @ R )
        @ ^ [Y3: $o,Z: $o] : ( Y3 = Z ) )
      @ ( pred_stream @ A )
      @ ( pred_stream @ B ) ) ).

% stream.pred_transfer
thf(fact_225_stream_Omap__transfer,axiom,
    ! [A: $tType,B: $tType,F4: $tType,E: $tType,Rb: A > E > $o,Sd: B > F4 > $o] : ( bNF_rel_fun @ ( A > B ) @ ( E > F4 ) @ ( ( stream @ A ) > ( stream @ B ) ) @ ( ( stream @ E ) > ( stream @ F4 ) ) @ ( bNF_rel_fun @ A @ E @ B @ F4 @ Rb @ Sd ) @ ( bNF_rel_fun @ ( stream @ A ) @ ( stream @ E ) @ ( stream @ B ) @ ( stream @ F4 ) @ ( stream_all2 @ A @ E @ Rb ) @ ( stream_all2 @ B @ F4 @ Sd ) ) @ ( smap @ A @ B ) @ ( smap @ E @ F4 ) ) ).

% stream.map_transfer
thf(fact_226_stream_Orel__coinduct,axiom,
    ! [A: $tType,B: $tType,P2: ( stream @ A ) > ( stream @ B ) > $o,X4: stream @ A,Y: stream @ B,R: A > B > $o] :
      ( ( P2 @ X4 @ Y )
     => ( ! [Stream3: stream @ A,Stream4: stream @ B] :
            ( ( P2 @ Stream3 @ Stream4 )
           => ( ( R @ ( shd @ A @ Stream3 ) @ ( shd @ B @ Stream4 ) )
              & ( P2 @ ( stl @ A @ Stream3 ) @ ( stl @ B @ Stream4 ) ) ) )
       => ( stream_all2 @ A @ B @ R @ X4 @ Y ) ) ) ).

% stream.rel_coinduct
thf(fact_227_stream_Orel__sel,axiom,
    ! [B: $tType,A: $tType] :
      ( ( stream_all2 @ A @ B )
      = ( ^ [R3: A > B > $o,A3: stream @ A,B4: stream @ B] :
            ( ( R3 @ ( shd @ A @ A3 ) @ ( shd @ B @ B4 ) )
            & ( stream_all2 @ A @ B @ R3 @ ( stl @ A @ A3 ) @ ( stl @ B @ B4 ) ) ) ) ) ).

% stream.rel_sel
thf(fact_228_list_Opred__set,axiom,
    ! [A: $tType] :
      ( ( list_all @ A )
      = ( ^ [P: A > $o,X5: list @ A] :
          ! [Y4: A] :
            ( ( member2 @ A @ Y4 @ ( set2 @ A @ X5 ) )
           => ( P @ Y4 ) ) ) ) ).

% list.pred_set
thf(fact_229_Ball__set__list__all,axiom,
    ! [A: $tType,Xs: list @ A,P2: A > $o] :
      ( ( ! [X5: A] :
            ( ( member2 @ A @ X5 @ ( set2 @ A @ Xs ) )
           => ( P2 @ X5 ) ) )
      = ( list_all @ A @ P2 @ Xs ) ) ).

% Ball_set_list_all
thf(fact_230_list__all__iff,axiom,
    ! [A: $tType] :
      ( ( list_all @ A )
      = ( ^ [P: A > $o,X5: list @ A] :
          ! [Y4: A] :
            ( ( member2 @ A @ Y4 @ ( set2 @ A @ X5 ) )
           => ( P @ Y4 ) ) ) ) ).

% list_all_iff
thf(fact_231_stream_Orel__cong,axiom,
    ! [A: $tType,B: $tType,X4: stream @ A,Ya: stream @ A,Y: stream @ B,Xa: stream @ B,R: A > B > $o,Ra: A > B > $o] :
      ( ( X4 = Ya )
     => ( ( Y = Xa )
       => ( ! [Z4: A,Yb: B] :
              ( ( member2 @ A @ Z4 @ ( sset @ A @ Ya ) )
             => ( ( member2 @ B @ Yb @ ( sset @ B @ Xa ) )
               => ( ( R @ Z4 @ Yb )
                  = ( Ra @ Z4 @ Yb ) ) ) )
         => ( ( stream_all2 @ A @ B @ R @ X4 @ Y )
            = ( stream_all2 @ A @ B @ Ra @ Ya @ Xa ) ) ) ) ) ).

% stream.rel_cong
thf(fact_232_stream_Orel__mono__strong,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X4: stream @ A,Y: stream @ B,Ra: A > B > $o] :
      ( ( stream_all2 @ A @ B @ R @ X4 @ Y )
     => ( ! [Z4: A,Yb: B] :
            ( ( member2 @ A @ Z4 @ ( sset @ A @ X4 ) )
           => ( ( member2 @ B @ Yb @ ( sset @ B @ Y ) )
             => ( ( R @ Z4 @ Yb )
               => ( Ra @ Z4 @ Yb ) ) ) )
       => ( stream_all2 @ A @ B @ Ra @ X4 @ Y ) ) ) ).

% stream.rel_mono_strong
thf(fact_233_stream_Orel__refl__strong,axiom,
    ! [A: $tType,X4: stream @ A,Ra: A > A > $o] :
      ( ! [Z4: A] :
          ( ( member2 @ A @ Z4 @ ( sset @ A @ X4 ) )
         => ( Ra @ Z4 @ Z4 ) )
     => ( stream_all2 @ A @ A @ Ra @ X4 @ X4 ) ) ).

% stream.rel_refl_strong
thf(fact_234_stream_Orel__map_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,Sa: A > C > $o,X4: stream @ A,G: B > C,Y: stream @ B] :
      ( ( stream_all2 @ A @ C @ Sa @ X4 @ ( smap @ B @ C @ G @ Y ) )
      = ( stream_all2 @ A @ B
        @ ^ [X5: A,Y4: B] : ( Sa @ X5 @ ( G @ Y4 ) )
        @ X4
        @ Y ) ) ).

% stream.rel_map(2)
thf(fact_235_stream_Orel__map_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,Sb: C > B > $o,I: A > C,X4: stream @ A,Y: stream @ B] :
      ( ( stream_all2 @ C @ B @ Sb @ ( smap @ A @ C @ I @ X4 ) @ Y )
      = ( stream_all2 @ A @ B
        @ ^ [X5: A] : ( Sb @ ( I @ X5 ) )
        @ X4
        @ Y ) ) ).

% stream.rel_map(1)
thf(fact_236_stream_Orel__refl,axiom,
    ! [B: $tType,Ra: B > B > $o,X4: stream @ B] :
      ( ! [X: B] : ( Ra @ X @ X )
     => ( stream_all2 @ B @ B @ Ra @ X4 @ X4 ) ) ).

% stream.rel_refl
thf(fact_237_stream_Orel__eq,axiom,
    ! [A: $tType] :
      ( ( stream_all2 @ A @ A
        @ ^ [Y3: A,Z: A] : ( Y3 = Z ) )
      = ( ^ [Y3: stream @ A,Z: stream @ A] : ( Y3 = Z ) ) ) ).

% stream.rel_eq
thf(fact_238_stream_Orel__intros,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X1: A,Y1: B,X22: stream @ A,Y2: stream @ B] :
      ( ( R @ X1 @ Y1 )
     => ( ( stream_all2 @ A @ B @ R @ X22 @ Y2 )
       => ( stream_all2 @ A @ B @ R @ ( sCons @ A @ X1 @ X22 ) @ ( sCons @ B @ Y1 @ Y2 ) ) ) ) ).

% stream.rel_intros
thf(fact_239_stream_Orel__cases,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,A2: stream @ A,B3: stream @ B] :
      ( ( stream_all2 @ A @ B @ R @ A2 @ B3 )
     => ~ ! [X1a: A,X2a: stream @ A] :
            ( ( A2
              = ( sCons @ A @ X1a @ X2a ) )
           => ! [Y1a: B,Y2a: stream @ B] :
                ( ( B3
                  = ( sCons @ B @ Y1a @ Y2a ) )
               => ( ( R @ X1a @ Y1a )
                 => ~ ( stream_all2 @ A @ B @ R @ X2a @ Y2a ) ) ) ) ) ).

% stream.rel_cases
thf(fact_240_list_Opred__cong,axiom,
    ! [A: $tType,X4: list @ A,Ya: list @ A,P2: A > $o,Pa: A > $o] :
      ( ( X4 = Ya )
     => ( ! [Z4: A] :
            ( ( member2 @ A @ Z4 @ ( set2 @ A @ Ya ) )
           => ( ( P2 @ Z4 )
              = ( Pa @ Z4 ) ) )
       => ( ( list_all @ A @ P2 @ X4 )
          = ( list_all @ A @ Pa @ Ya ) ) ) ) ).

% list.pred_cong
thf(fact_241_list_Opred__mono__strong,axiom,
    ! [A: $tType,P2: A > $o,X4: list @ A,Pa: A > $o] :
      ( ( list_all @ A @ P2 @ X4 )
     => ( ! [Z4: A] :
            ( ( member2 @ A @ Z4 @ ( set2 @ A @ X4 ) )
           => ( ( P2 @ Z4 )
             => ( Pa @ Z4 ) ) )
       => ( list_all @ A @ Pa @ X4 ) ) ) ).

% list.pred_mono_strong
thf(fact_242_list_Opred__True,axiom,
    ! [A: $tType] :
      ( ( list_all @ A
        @ ^ [Uu: A] : $true )
      = ( ^ [Uu: list @ A] : $true ) ) ).

% list.pred_True
thf(fact_243_stream__all__shift,axiom,
    ! [A: $tType,P2: A > $o,Xs: list @ A,S2: stream @ A] :
      ( ( stream_all @ A @ P2 @ ( shift @ A @ Xs @ S2 ) )
      = ( ( list_all @ A @ P2 @ Xs )
        & ( stream_all @ A @ P2 @ S2 ) ) ) ).

% stream_all_shift
thf(fact_244_treeFI_Opred__map,axiom,
    ! [B: $tType,A: $tType,Q: B > $o,F2: A > B,X4: treeFI @ A] :
      ( ( pred_treeFI @ B @ Q @ ( map_treeFI @ A @ B @ F2 @ X4 ) )
      = ( pred_treeFI @ A @ ( comp @ B @ $o @ A @ Q @ F2 ) @ X4 ) ) ).

% treeFI.pred_map
thf(fact_245_shift__left__inj,axiom,
    ! [A: $tType,Xs: list @ A,S12: stream @ A,S23: stream @ A] :
      ( ( ( shift @ A @ Xs @ S12 )
        = ( shift @ A @ Xs @ S23 ) )
      = ( S12 = S23 ) ) ).

% shift_left_inj
thf(fact_246_treeFI_Omap__transfer,axiom,
    ! [A: $tType,B: $tType,F4: $tType,E: $tType,Rb: A > E > $o,Sd: B > F4 > $o] : ( bNF_rel_fun @ ( A > B ) @ ( E > F4 ) @ ( ( treeFI @ A ) > ( treeFI @ B ) ) @ ( ( treeFI @ E ) > ( treeFI @ F4 ) ) @ ( bNF_rel_fun @ A @ E @ B @ F4 @ Rb @ Sd ) @ ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ E ) @ ( treeFI @ B ) @ ( treeFI @ F4 ) @ ( rel_treeFI @ A @ E @ Rb ) @ ( rel_treeFI @ B @ F4 @ Sd ) ) @ ( map_treeFI @ A @ B ) @ ( map_treeFI @ E @ F4 ) ) ).

% treeFI.map_transfer
thf(fact_247_treeFI_Omap__ident,axiom,
    ! [A: $tType,T: treeFI @ A] :
      ( ( map_treeFI @ A @ A
        @ ^ [X5: A] : X5
        @ T )
      = T ) ).

% treeFI.map_ident
thf(fact_248_treeFI_Omap__cong,axiom,
    ! [B: $tType,A: $tType,X4: treeFI @ A,Ya: treeFI @ A,F2: A > B,G: A > B] :
      ( ( X4 = Ya )
     => ( ! [Z4: A] :
            ( ( member2 @ A @ Z4 @ ( set_treeFI @ A @ Ya ) )
           => ( ( F2 @ Z4 )
              = ( G @ Z4 ) ) )
       => ( ( map_treeFI @ A @ B @ F2 @ X4 )
          = ( map_treeFI @ A @ B @ G @ Ya ) ) ) ) ).

% treeFI.map_cong
thf(fact_249_treeFI_Omap__cong0,axiom,
    ! [B: $tType,A: $tType,X4: treeFI @ A,F2: A > B,G: A > B] :
      ( ! [Z4: A] :
          ( ( member2 @ A @ Z4 @ ( set_treeFI @ A @ X4 ) )
         => ( ( F2 @ Z4 )
            = ( G @ Z4 ) ) )
     => ( ( map_treeFI @ A @ B @ F2 @ X4 )
        = ( map_treeFI @ A @ B @ G @ X4 ) ) ) ).

% treeFI.map_cong0
thf(fact_250_treeFI_Oinj__map__strong,axiom,
    ! [B: $tType,A: $tType,X4: treeFI @ A,Xa: treeFI @ A,F2: A > B,Fa: A > B] :
      ( ! [Z4: A,Za: A] :
          ( ( member2 @ A @ Z4 @ ( set_treeFI @ A @ X4 ) )
         => ( ( member2 @ A @ Za @ ( set_treeFI @ A @ Xa ) )
           => ( ( ( F2 @ Z4 )
                = ( Fa @ Za ) )
             => ( Z4 = Za ) ) ) )
     => ( ( ( map_treeFI @ A @ B @ F2 @ X4 )
          = ( map_treeFI @ A @ B @ Fa @ Xa ) )
       => ( X4 = Xa ) ) ) ).

% treeFI.inj_map_strong
thf(fact_251_treeFI_Omap__sel_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: A > B,A2: treeFI @ A] :
      ( ( lab @ B @ ( map_treeFI @ A @ B @ F2 @ A2 ) )
      = ( F2 @ ( lab @ A @ A2 ) ) ) ).

% treeFI.map_sel(1)
thf(fact_252_treeFI_Orel__map_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,Sb: C > B > $o,I: A > C,X4: treeFI @ A,Y: treeFI @ B] :
      ( ( rel_treeFI @ C @ B @ Sb @ ( map_treeFI @ A @ C @ I @ X4 ) @ Y )
      = ( rel_treeFI @ A @ B
        @ ^ [X5: A] : ( Sb @ ( I @ X5 ) )
        @ X4
        @ Y ) ) ).

% treeFI.rel_map(1)
thf(fact_253_treeFI_Orel__map_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,Sa: A > C > $o,X4: treeFI @ A,G: B > C,Y: treeFI @ B] :
      ( ( rel_treeFI @ A @ C @ Sa @ X4 @ ( map_treeFI @ B @ C @ G @ Y ) )
      = ( rel_treeFI @ A @ B
        @ ^ [X5: A,Y4: B] : ( Sa @ X5 @ ( G @ Y4 ) )
        @ X4
        @ Y ) ) ).

% treeFI.rel_map(2)
thf(fact_254_treeFI_Omap__comp,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: B > C,F2: A > B,V: treeFI @ A] :
      ( ( map_treeFI @ B @ C @ G @ ( map_treeFI @ A @ B @ F2 @ V ) )
      = ( map_treeFI @ A @ C @ ( comp @ B @ C @ A @ G @ F2 ) @ V ) ) ).

% treeFI.map_comp
thf(fact_255_treeFI_Omap__cong__pred,axiom,
    ! [B: $tType,A: $tType,X4: treeFI @ A,Ya: treeFI @ A,F2: A > B,G: A > B] :
      ( ( X4 = Ya )
     => ( ( pred_treeFI @ A
          @ ^ [Z3: A] :
              ( ( F2 @ Z3 )
              = ( G @ Z3 ) )
          @ Ya )
       => ( ( map_treeFI @ A @ B @ F2 @ X4 )
          = ( map_treeFI @ A @ B @ G @ Ya ) ) ) ) ).

% treeFI.map_cong_pred

%----Type constructors (5)
thf(tcon_fun___Orderings_Oord,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ord @ A9 @ ( type2 @ A9 ) )
     => ( ord @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oord_1,axiom,
    ord @ nat @ ( type2 @ nat ) ).

thf(tcon_Set_Oset___Orderings_Oord_2,axiom,
    ! [A8: $tType] : ( ord @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_HOL_Obool___Orderings_Oord_3,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P2: $o] :
      ( ( P2 = $true )
      | ( P2 = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X4: A,Y: A] :
      ( ( if @ A @ $false @ X4 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X4: A,Y: A] :
      ( ( if @ A @ $true @ X4 @ Y )
      = X4 ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    koenig1755522246erPath @ a @ ( koenig1103336060igPath @ a @ tr ) @ tr ).

%------------------------------------------------------------------------------
